/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.commons.repositories.core.auth.UnavailableException;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.commons.repositories.core.LocationService;
import org.eclipse.mylyn.internal.commons.repositories.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class RepositoryUiUtil {
    private RepositoryUiUtil() {
    }

    public static void testCredentialsStore(String id, DialogPage page) {
        ICredentialsStore store = LocationService.getDefault().getCredentialsStore(id);
        try {
            store.testAvailability();
        }
        catch (UnavailableException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.core", NLS.bind((String)"Credential store not available with ID {0}", (Object)id), (Throwable)e));
            page.setErrorMessage(Messages.RepositoryUiUtil_secure_storage_unavailable);
        }
    }

    public static <T> T adapt(Object sourceObject, Class<T> adapter) {
        try {
            if (PlatformUiUtil.isNeonOrLater()) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
                Class clazz = bundle.loadClass("org.eclipse.core.runtime.Adapters");
                Method adaptMethod = clazz.getMethod("adapt", Object.class, Class.class);
                Object result = adaptMethod.invoke((Object)clazz, sourceObject, adapter);
                return (T)result;
            }
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
            Class clazz = bundle.loadClass("org.eclipse.ui.internal.util.Util");
            Method adaptMethod = clazz.getMethod("getAdapter", Object.class, Class.class);
            Object result = adaptMethod.invoke((Object)clazz, sourceObject, adapter);
            return (T)result;
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.ui", "Could not adapt", (Throwable)e));
            return null;
        }
    }
}

