/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.operations;

import com.google.gerrit.common.data.ReviewerResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.Messages;

public class RemoveReviewerRequest
extends AbstractRequest<ReviewerResult> {
    private final String reviewer;
    private final String reviewId;

    public RemoveReviewerRequest(String reviewId, String reviewer) {
        Assert.isNotNull((Object)reviewId);
        Assert.isNotNull((Object)reviewer);
        this.reviewId = reviewId;
        this.reviewer = reviewer;
    }

    public String getReviewerToRemove() {
        return this.reviewer;
    }

    public String getReviewId() {
        return this.reviewId;
    }

    @Override
    protected ReviewerResult execute(GerritClient client, IProgressMonitor monitor) throws GerritException {
        return client.removeReviewer(this.getReviewId(), this.getReviewerToRemove(), monitor);
    }

    @Override
    public String getOperationName() {
        return Messages.RemoveReviewerRequest_Remove_Reviewer;
    }
}

