/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.commons.ui.ClipboardCopier;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyDetailsHandler
extends AbstractHandler {
    public static void copyDetails(List<IBuildElement> elements, final Mode mode) {
        ClipboardCopier.getDefault().copy(elements, new ClipboardCopier.TextProvider(){

            public String getTextForElement(Object element) {
                return CopyDetailsHandler.getTextFor(element, mode);
            }
        });
    }

    public static String getTextFor(Object object) {
        return CopyDetailsHandler.getTextFor(object, Mode.SUMMARY_URL);
    }

    public static String getTextFor(Object object, Mode mode) {
        StringBuffer sb = new StringBuffer();
        switch (mode) {
            case KEY: {
                if (object instanceof IBuild) {
                    IBuild build = (IBuild)object;
                    if (build.getId() == null) break;
                    sb.append(build.getId());
                    break;
                }
                if (!(object instanceof IBuildElement)) break;
                IBuildElement element = (IBuildElement)object;
                sb.append(element.getLabel());
                break;
            }
            case URL: {
                IBuildElement element;
                if (!(object instanceof IBuildElement) || (element = (IBuildElement)object).getUrl() == null) break;
                sb.append(element.getUrl());
                break;
            }
            case SUMMARY: {
                if (object instanceof IBuild) {
                    IBuild build = (IBuild)object;
                    if (build.getLabel() == null) break;
                    sb.append(NLS.bind((String)"Build {0}", (Object)build.getLabel()));
                    break;
                }
                if (!(object instanceof IBuildElement)) break;
                IBuildElement element = (IBuildElement)object;
                sb.append(element.getLabel());
                break;
            }
            case SUMMARY_URL: {
                IBuild build;
                if (!(object instanceof IBuildElement)) break;
                IBuildElement element = (IBuildElement)object;
                if (object instanceof IBuild && (build = (IBuild)object).getLabel() != null) {
                    sb.append(NLS.bind((String)"Build {0}", (Object)build.getLabel()));
                }
                sb.append(element.getLabel());
                if (!TasksUiInternal.isValidUrl((String)element.getUrl())) break;
                sb.append(ClipboardCopier.LINE_SEPARATOR);
                sb.append(element.getUrl());
            }
        }
        return sb.toString();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Mode mode = Mode.SUMMARY;
            String kind = event.getParameter("kind");
            if (kind != null) {
                try {
                    mode = Mode.valueOf(kind);
                }
                catch (IllegalArgumentException e) {
                    throw new ExecutionException(NLS.bind((String)"Invalid kind ''{0}'' specified", (Object)kind));
                }
            }
            CopyDetailsHandler.copyDetails(BuildsUiInternal.getElements(event), mode);
        }
        return null;
    }

    public static enum Mode {
        KEY,
        SUMMARY,
        SUMMARY_URL,
        URL;


        public String toString() {
            switch (this) {
                case KEY: {
                    return "ID";
                }
                case URL: {
                    return "URL";
                }
                case SUMMARY: {
                    return "Summary";
                }
                case SUMMARY_URL: {
                    return "Summary and URL";
                }
            }
            return null;
        }
    }
}

