/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Change;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;

public final class ChangeMessage {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2, name="author_id", notNull=false)
    protected Account.Id author;
    @Column(id=3)
    protected Timestamp writtenOn;
    @Column(id=4, notNull=false, length=0x7FFFFFFF)
    protected String message;

    protected ChangeMessage() {
    }

    public ChangeMessage(Key k, Account.Id a) {
        this(k, a, new Timestamp(System.currentTimeMillis()));
    }

    public ChangeMessage(Key k, Account.Id a, Timestamp wo) {
        this.key = k;
        this.author = a;
        this.writtenOn = wo;
    }

    public Key getKey() {
        return this.key;
    }

    public Account.Id getAuthor() {
        return this.author;
    }

    public void setAuthor(Account.Id accountId) {
        if (this.author != null) {
            throw new IllegalStateException("Cannot modify author once assigned");
        }
        this.author = accountId;
    }

    public Timestamp getWrittenOn() {
        return this.writtenOn;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public static class Key
    extends StringKey<Change.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Change.Id changeId;
        @Column(id=2, length=40)
        protected String uuid;

        protected Key() {
            this.changeId = new Change.Id();
        }

        public Key(Change.Id change, String uuid) {
            this.changeId = change;
            this.uuid = uuid;
        }

        public Change.Id getParentKey() {
            return this.changeId;
        }

        public String get() {
            return this.uuid;
        }

        protected void set(String newValue) {
            this.uuid = newValue;
        }
    }
}

