/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class AsyncFragmentLoader {
    public static AsyncFragmentLoader BROWSER_LOADER = new AsyncFragmentLoader(1, new int[0], new XhrLoadingStrategy(), new StandardLogger());
    private static final String HTTP_GET = "GET";
    private static final int HTTP_STATUS_NON_HTTP = 0;
    private static final int HTTP_STATUS_OK = 200;
    private Map<Integer, LoadErrorHandler> initialFragmentErrorHandlers = new HashMap<Integer, LoadErrorHandler>();
    private boolean initialFragmentsLoading = false;
    private final int[] initialLoadSequence;
    private LoadingStrategy loadingStrategy = new XhrLoadingStrategy();
    private final Logger logger;
    private final int numEntries;
    private BoundedIntQueue remainingInitialFragments = null;
    private final BoundedIntQueue waitingForInitialFragments;
    private Queue<LoadErrorHandler> waitingForInitialFragmentsErrorHandlers = new LinkedList<LoadErrorHandler>();

    public static void browserLoaderLeftoversFragmentHasLoaded() {
        BROWSER_LOADER.leftoversFragmentHasLoaded();
    }

    public AsyncFragmentLoader(int numEntries, int[] initialLoadSequence, LoadingStrategy loadingStrategy, Logger logger) {
        this.numEntries = numEntries;
        this.initialLoadSequence = initialLoadSequence;
        this.loadingStrategy = loadingStrategy;
        this.logger = logger;
        this.waitingForInitialFragments = new BoundedIntQueue(numEntries + 1);
    }

    public void fragmentHasLoaded(int fragment) {
        this.logFragmentLoaded(fragment);
        if (this.isInitial(fragment)) {
            assert (fragment == this.remainingInitialFragments.peek());
            this.remainingInitialFragments.remove();
            this.initialFragmentErrorHandlers.remove(fragment);
            this.startLoadingNextInitial();
        }
    }

    public void inject(int splitPoint, LoadErrorHandler loadErrorHandler) {
        if (this.haveInitialFragmentsLoaded()) {
            this.logDownloadStart(splitPoint);
            this.startLoadingFragment(splitPoint, loadErrorHandler);
            return;
        }
        if (this.isInitial(splitPoint)) {
            this.initialFragmentErrorHandlers.put(splitPoint, loadErrorHandler);
        } else {
            assert (this.waitingForInitialFragments.size() == this.waitingForInitialFragmentsErrorHandlers.size());
            this.waitingForInitialFragments.add(splitPoint);
            this.waitingForInitialFragmentsErrorHandlers.add(loadErrorHandler);
        }
        if (!this.initialFragmentsLoading) {
            this.startLoadingNextInitial();
        }
    }

    public void leftoversFragmentHasLoaded() {
        this.fragmentHasLoaded(this.leftoversFragment());
    }

    public void logEventProgress(String eventGroup, String type) {
        this.logEventProgress(eventGroup, type, null, null);
    }

    private String downloadGroup(int fragment) {
        return fragment == this.leftoversFragment() ? "leftoversDownload" : LwmLabels.downloadGroupForExclusive(fragment);
    }

    private boolean haveInitialFragmentsLoaded() {
        return this.remainingInitialFragments != null && this.remainingInitialFragments.size() == 0;
    }

    private boolean isInitial(int splitPoint) {
        if (splitPoint == this.leftoversFragment()) {
            return true;
        }
        for (int sp : this.initialLoadSequence) {
            if (sp != splitPoint) continue;
            return true;
        }
        return false;
    }

    private int leftoversFragment() {
        return this.numEntries;
    }

    private void logDownloadStart(int fragment) {
        this.logEventProgress(this.downloadGroup(fragment), "begin", fragment, null);
    }

    private void logEventProgress(String eventGroup, String type, Integer fragment, Integer size) {
        this.logger.logEventProgress(eventGroup, type, fragment, size);
    }

    private void logFragmentLoaded(int fragment) {
        String logGroup = this.downloadGroup(fragment);
        this.logEventProgress(logGroup, "end", fragment, null);
    }

    private void startLoadingFragment(int fragment, LoadErrorHandler loadErrorHandler) {
        this.loadingStrategy.startLoadingFragment(fragment, loadErrorHandler);
    }

    private void startLoadingNextInitial() {
        if (this.remainingInitialFragments == null) {
            this.remainingInitialFragments = new BoundedIntQueue(this.initialLoadSequence.length + 1);
            for (int sp : this.initialLoadSequence) {
                this.remainingInitialFragments.add(sp);
            }
            this.remainingInitialFragments.add(this.leftoversFragment());
        }
        if (this.initialFragmentErrorHandlers.isEmpty() && this.waitingForInitialFragmentsErrorHandlers.isEmpty() && this.remainingInitialFragments.size() > 1) {
            this.initialFragmentsLoading = false;
            return;
        }
        if (this.remainingInitialFragments.size() > 0) {
            this.initialFragmentsLoading = true;
            int nextSplitPoint = this.remainingInitialFragments.peek();
            this.logDownloadStart(nextSplitPoint);
            this.startLoadingFragment(nextSplitPoint, new InitialFragmentDownloadFailed());
            return;
        }
        this.initialFragmentsLoading = false;
        assert (this.haveInitialFragmentsLoaded());
        assert (this.waitingForInitialFragments.size() == this.waitingForInitialFragmentsErrorHandlers.size());
        while (this.waitingForInitialFragments.size() > 0) {
            int nextSplitPoint = this.waitingForInitialFragments.remove();
            LoadErrorHandler handler = this.waitingForInitialFragmentsErrorHandlers.remove();
            this.logDownloadStart(nextSplitPoint);
            this.startLoadingFragment(nextSplitPoint, handler);
        }
    }

    private static class BoundedIntQueue {
        private final int[] array;
        private int read = 0;
        private int write = 0;

        public BoundedIntQueue(int maxPuts) {
            this.array = new int[maxPuts];
        }

        public void add(int x) {
            assert (this.write < this.array.length);
            this.array[this.write++] = x;
        }

        public void clear() {
            this.read = 0;
            this.write = 0;
        }

        public int peek() {
            assert (this.read < this.write);
            return this.array[this.read];
        }

        public int remove() {
            assert (this.read < this.write);
            return this.array[this.read++];
        }

        public int size() {
            return this.write - this.read;
        }
    }

    private static class HttpDownloadFailure
    extends RuntimeException {
        private final int statusCode;

        public HttpDownloadFailure(int statusCode) {
            super("HTTP download failed with status " + statusCode);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    private class InitialFragmentDownloadFailed
    implements LoadErrorHandler {
        private InitialFragmentDownloadFailed() {
        }

        public void loadFailed(Throwable reason) {
            AsyncFragmentLoader.this.initialFragmentsLoading = false;
            ArrayList<Object> handlersToRun = new ArrayList<Object>();
            assert (AsyncFragmentLoader.this.waitingForInitialFragments.size() == AsyncFragmentLoader.this.waitingForInitialFragmentsErrorHandlers.size());
            while (AsyncFragmentLoader.this.waitingForInitialFragments.size() > 0) {
                handlersToRun.add(AsyncFragmentLoader.this.waitingForInitialFragmentsErrorHandlers.remove());
                AsyncFragmentLoader.this.waitingForInitialFragments.remove();
            }
            AsyncFragmentLoader.this.waitingForInitialFragments.clear();
            handlersToRun.addAll(AsyncFragmentLoader.this.initialFragmentErrorHandlers.values());
            AsyncFragmentLoader.this.initialFragmentErrorHandlers.clear();
            RuntimeException lastException = null;
            for (LoadErrorHandler loadErrorHandler : handlersToRun) {
                try {
                    loadErrorHandler.loadFailed(reason);
                }
                catch (RuntimeException e) {
                    lastException = e;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
    }

    public static interface LoadErrorHandler {
        public void loadFailed(Throwable var1);
    }

    public static interface LoadingStrategy {
        public void startLoadingFragment(int var1, LoadErrorHandler var2);
    }

    public static interface Logger {
        public void logEventProgress(String var1, String var2, Integer var3, Integer var4);
    }

    public static class LwmLabels {
        public static final String BEGIN = "begin";
        public static final String END = "end";
        private static final String LEFTOVERS_DOWNLOAD = "leftoversDownload";

        private static String downloadGroupForExclusive(int splitPoint) {
            return "download" + splitPoint;
        }
    }

    private static class StandardLogger
    implements Logger {
        private StandardLogger() {
        }

        private static native boolean stats(JavaScriptObject var0);

        public void logEventProgress(String eventGroup, String type, Integer fragment, Integer size) {
            boolean toss = this.isStatsAvailable() && StandardLogger.stats(this.createStatsEvent(eventGroup, type, fragment, size));
        }

        private native JavaScriptObject createStatsEvent(String var1, String var2, Integer var3, Integer var4);

        private native boolean isStatsAvailable();
    }

    private static class XhrLoadingStrategy
    implements LoadingStrategy {
        private XhrLoadingStrategy() {
        }

        public void startLoadingFragment(int fragment, final LoadErrorHandler loadErrorHandler) {
            String fragmentUrl = this.gwtStartLoadingFragment(fragment, loadErrorHandler);
            if (fragmentUrl == null) {
                return;
            }
            final XMLHttpRequest xhr = XMLHttpRequest.create();
            xhr.open(AsyncFragmentLoader.HTTP_GET, fragmentUrl);
            xhr.setOnReadyStateChange(new ReadyStateChangeHandler(){

                public void onReadyStateChange(XMLHttpRequest ignored) {
                    if (xhr.getReadyState() == 4) {
                        xhr.clearOnReadyStateChange();
                        if ((xhr.getStatus() == 200 || xhr.getStatus() == 0) && xhr.getResponseText() != null && xhr.getResponseText().length() != 0) {
                            try {
                                XhrLoadingStrategy.this.gwtInstallCode(xhr.getResponseText());
                            }
                            catch (RuntimeException e) {
                                loadErrorHandler.loadFailed(e);
                            }
                        } else {
                            loadErrorHandler.loadFailed(new HttpDownloadFailure(xhr.getStatus()));
                        }
                    }
                }
            });
            xhr.send();
        }

        private native void gwtInstallCode(String var1);

        private native String gwtStartLoadingFragment(int var1, LoadErrorHandler var2);
    }
}

