/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css.ast;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CssProperty
extends CssNode {
    private boolean important;
    private String name;
    private ListValue value;

    public CssProperty(String name, Value value, boolean important) {
        assert (name.length() > 0) : "name";
        this.name = name;
        this.setValue(value);
        this.important = important;
    }

    public String getName() {
        return this.name;
    }

    public ListValue getValues() {
        return this.value;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Value value) {
        this.value = value.isListValue();
        if (this.value == null) {
            this.value = new ListValue(value);
        }
    }

    public void traverse(CssVisitor visitor, Context context) {
        visitor.visit(this, context);
        visitor.endVisit(this, context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DotPathValue
    extends Value {
        private final String path;
        private final String suffix;

        public DotPathValue(String path) {
            assert (path != null) : "path";
            this.path = path;
            this.suffix = null;
        }

        public DotPathValue(String path, String suffix) {
            assert (path != null) : "path";
            assert (suffix != null) : "suffix";
            this.path = path;
            this.suffix = suffix;
        }

        @Override
        public String getExpression() {
            StringBuilder toReturn = new StringBuilder();
            toReturn.append(this.path.replace(".", "()."));
            toReturn.append("()");
            if (this.suffix != null) {
                toReturn.append(" + \"");
                toReturn.append(Generator.escape((String)this.suffix));
                toReturn.append("\"");
            }
            return toReturn.toString();
        }

        public List<String> getParts() {
            return Arrays.asList(this.path.split("\\."));
        }

        public String getPath() {
            return this.path;
        }

        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public DotPathValue isDotPathValue() {
            return this;
        }

        @Override
        public String toCss() {
            return "value(\"" + this.path + "\"" + (this.suffix == null ? "" : ", \"" + this.suffix + "\"") + ")";
        }
    }

    public static class ExpressionValue
    extends Value {
        private final String expression;

        public ExpressionValue(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public ExpressionValue isExpressionValue() {
            return this;
        }

        public String toCss() {
            return "/* Java expression */";
        }

        public String toString() {
            return this.expression;
        }
    }

    public static class IdentValue
    extends Value {
        private final String ident;

        public IdentValue(String ident) {
            this.ident = ident;
        }

        public String getExpression() {
            return '\"' + Generator.escape((String)this.ident) + '\"';
        }

        public String getIdent() {
            return this.ident;
        }

        public IdentValue isIdentValue() {
            return this;
        }

        public String toCss() {
            return this.ident;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListValue
    extends Value {
        private final List<Value> values;

        public ListValue(List<Value> values) {
            this.values = Collections.unmodifiableList(new ArrayList<Value>(values));
        }

        public ListValue(Value ... values) {
            this(Arrays.asList(values));
        }

        @Override
        public String getExpression() {
            StringBuilder toReturn = new StringBuilder();
            boolean first = true;
            Iterator<Value> i = this.values.iterator();
            while (i.hasNext()) {
                Value value = i.next();
                if (!first && value.isSpaceRequired()) {
                    toReturn.append("\" \" +");
                }
                toReturn.append(value.getExpression());
                if (i.hasNext()) {
                    toReturn.append("+ ");
                }
                first = false;
            }
            return toReturn.toString();
        }

        public List<Value> getValues() {
            return this.values;
        }

        @Override
        public ListValue isListValue() {
            return this;
        }

        @Override
        public String toCss() {
            StringBuilder sb = new StringBuilder();
            for (Value v : this.values) {
                sb.append(" ").append(v.toCss());
            }
            return sb.substring(1);
        }
    }

    public static class NumberValue
    extends Value {
        private final String css;
        private final String expression;
        private final String units;
        private final float value;

        public NumberValue(float value) {
            this(value, null);
        }

        public NumberValue(float value, String units) {
            this.value = value;
            this.units = units;
            int i = (int)value;
            String s = (float)i == value ? String.valueOf(i) : String.valueOf(value);
            if (units != null && value != 0.0f) {
                this.css = s + units;
                this.expression = '\"' + s + Generator.escape((String)units) + '\"';
            } else if (value == 0.0f) {
                this.css = "0";
                this.expression = "\"0\"";
            } else {
                this.css = s;
                this.expression = '\"' + s + '\"';
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public String getUnits() {
            return this.units;
        }

        public float getValue() {
            return this.value;
        }

        public NumberValue isNumberValue() {
            return this;
        }

        public String toCss() {
            return this.css;
        }
    }

    public static class StringValue
    extends Value {
        private final String value;

        private static String escapeValue(String s, boolean inDoubleQuotes) {
            StringBuilder b = new StringBuilder();
            block5: for (char c : s.toCharArray()) {
                if (Character.isISOControl(c)) {
                    b.append('\\').append(Integer.toHexString(c).toUpperCase()).append(" ");
                    continue;
                }
                switch (c) {
                    case '\'': {
                        if (inDoubleQuotes) {
                            b.append(c);
                            continue block5;
                        }
                        b.append("\\'");
                        continue block5;
                    }
                    case '\"': {
                        if (inDoubleQuotes) {
                            b.append("\\\"");
                            continue block5;
                        }
                        b.append(c);
                        continue block5;
                    }
                    case '\\': {
                        b.append("\\\\");
                        continue block5;
                    }
                    default: {
                        b.append(c);
                    }
                }
            }
            return b.toString();
        }

        public StringValue(String value) {
            this.value = value;
        }

        public String getExpression() {
            return "\"" + Generator.escape((String)this.toCss()) + "\"";
        }

        public String getValue() {
            return this.value;
        }

        public StringValue isStringValue() {
            return this;
        }

        public String toCss() {
            return '\"' + StringValue.escapeValue(this.value, true) + '\"';
        }
    }

    public static class TokenValue
    extends IdentValue {
        public TokenValue(String token) {
            super(token);
        }

        public boolean isSpaceRequired() {
            return false;
        }
    }

    public static abstract class Value {
        public abstract String getExpression();

        public DotPathValue isDotPathValue() {
            return null;
        }

        public ExpressionValue isExpressionValue() {
            return null;
        }

        public IdentValue isIdentValue() {
            return null;
        }

        public ListValue isListValue() {
            return null;
        }

        public NumberValue isNumberValue() {
            return null;
        }

        public boolean isSpaceRequired() {
            return true;
        }

        public StringValue isStringValue() {
            return null;
        }

        public abstract String toCss();

        public String toString() {
            return this.toCss();
        }
    }
}

