/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

public class GitWebType {
    private String revision;
    private String project;
    private String branch;

    public static GitWebType fromName(String name) {
        GitWebType type;
        if (name == null || name.isEmpty() || name.equalsIgnoreCase("gitweb")) {
            type = new GitWebType();
            type.setProject("?p=${project}.git;a=summary");
            type.setRevision("?p=${project}.git;a=commit;h=${commit}");
            type.setBranch("?p=${project}.git;a=shortlog;h=${branch}");
        } else if (name.equalsIgnoreCase("cgit")) {
            type = new GitWebType();
            type.setProject("${project}/summary");
            type.setRevision("${project}/commit/?id=${commit}");
            type.setBranch("${project}/log/?h=${branch}");
        } else {
            type = name.equalsIgnoreCase("custom") ? new GitWebType() : null;
        }
        return type;
    }

    protected GitWebType() {
    }

    public String getBranch() {
        return this.branch;
    }

    public String getProject() {
        return this.project;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setBranch(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.branch = pattern;
        }
    }

    public void setProject(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.project = pattern;
        }
    }

    public void setRevision(String pattern) {
        if (pattern != null && !pattern.isEmpty()) {
            this.revision = pattern;
        }
    }
}

