/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemCompareEditorInput;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemCompareEditorInput;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GerritCompareUi {
    public static CompareEditorInput getReviewItemSetComparisonEditor(ReviewItemSetCompareEditorInput editorInput, IReviewItemSet items, String taskId) {
        return GerritCompareUi.getComparisonEditor((CompareEditorInput)editorInput, GerritCompareUi.getReviewItemSetComparePredicate(items, taskId));
    }

    public static void openCompareEditor(CompareEditorInput input) {
        CompareUI.openCompareEditor((CompareEditorInput)input);
    }

    public static void openFileComparisonEditor(CompareConfiguration configuration, IFileItem item, ReviewBehavior behavior) {
        GerritCompareUi.openFileComparisonEditor(configuration, item, behavior, null);
    }

    public static void openFileComparisonEditor(CompareConfiguration configuration, IFileItem item, ReviewBehavior behavior, IStructuredSelection selection) {
        IComment comment = null;
        if (selection != null && selection.getFirstElement() instanceof IComment) {
            comment = (IComment)selection.getFirstElement();
        }
        GerritCompareUi.openFileComparisonEditor(configuration, item, behavior, comment);
    }

    public static void openFileComparisonEditor(CompareConfiguration configuration, IFileItem item, ReviewBehavior behavior, IComment comment) {
        FileItemCompareEditorInput editorInput = new FileItemCompareEditorInput(configuration, item, behavior);
        CompareEditorInput newInput = GerritCompareUi.getComparisonEditor((CompareEditorInput)editorInput, GerritCompareUi.getFileComparePredicate(item));
        GerritCompareUi.openCompareEditor(newInput);
        if (comment != null && newInput instanceof ReviewItemCompareEditorInput) {
            ((ReviewItemCompareEditorInput)newInput).gotoComment(comment);
        }
    }

    private static CompareEditorInput getComparisonEditor(CompareEditorInput editorInput, Predicate<CompareEditorInput> function) {
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        return GerritCompareUi.getComparisonEditorInput(editorReferences, editorInput, function);
    }

    static CompareEditorInput getComparisonEditorInput(IEditorReference[] editorReferences, CompareEditorInput editorInput, Predicate<CompareEditorInput> predicate) {
        return (CompareEditorInput)FluentIterable.from((Iterable)Lists.newArrayList((Object[])editorReferences)).filter((Predicate)new Predicate<IEditorReference>(){

            public boolean apply(IEditorReference ref) {
                return ref.getId().equals("org.eclipse.compare.CompareEditor");
            }
        }).transform((Function)new Function<IEditorReference, CompareEditorInput>(){

            public CompareEditorInput apply(IEditorReference reference) {
                try {
                    return (CompareEditorInput)reference.getEditorInput();
                }
                catch (PartInitException e) {
                    GerritCompareUi.handleError(e);
                    return null;
                }
            }
        }).firstMatch(predicate).or((Object)editorInput);
    }

    static Predicate<CompareEditorInput> getFileComparePredicate(final IFileItem item) {
        return new Predicate<CompareEditorInput>(){

            public boolean apply(CompareEditorInput existingEditorInput) {
                if (existingEditorInput instanceof FileItemCompareEditorInput) {
                    return ((FileItemCompareEditorInput)existingEditorInput).getFileItemId().equals(item.getId());
                }
                return false;
            }
        };
    }

    static Predicate<CompareEditorInput> getReviewItemSetComparePredicate(final IReviewItemSet itemSet, final String taskId) {
        return new Predicate<CompareEditorInput>(){

            public boolean apply(CompareEditorInput existingEditorInput) {
                if (existingEditorInput instanceof ReviewItemSetCompareEditorInput) {
                    return ((ReviewItemSetCompareEditorInput)existingEditorInput).getName().equals(itemSet.getName()) && taskId.equals(((ReviewItemSetCompareEditorInput)existingEditorInput).getItemTaskId());
                }
                return false;
            }
        };
    }

    protected static void handleError(PartInitException error) {
        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "There was an error restoring the editor input.", (Throwable)error));
    }
}

