/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskBuilder;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SaxTaskBuilderTest {
    private SaxTaskBuilder builder;

    @Before
    public void setup() {
        TaskList taskList = new TaskList();
        IRepositoryManager repositoryManager = (IRepositoryManager)Mockito.mock(IRepositoryManager.class);
        ((IRepositoryManager)Mockito.doReturn((Object)Mockito.mock(AbstractRepositoryConnector.class)).when((Object)repositoryManager)).getRepositoryConnector("connector.kind");
        ((IRepositoryManager)Mockito.doReturn((Object)Mockito.mock(LocalRepositoryConnector.class)).when((Object)repositoryManager)).getRepositoryConnector("local");
        this.builder = new SaxTaskBuilder(new RepositoryModel(taskList, repositoryManager), repositoryManager);
    }

    @Test
    public void minimalTask() throws Exception {
        AttributesImpl elementAttributes = this.createAttributes((Map<String, String>)ImmutableMap.of((Object)"Handle", (Object)"1", (Object)"TaskId", (Object)"100", (Object)"RepositoryUrl", (Object)"http://example.com", (Object)"ConnectorKind", (Object)"connector.kind"));
        this.builder.beginItem((Attributes)elementAttributes);
        Assert.assertTrue((boolean)this.builder.getErrors().isOK());
        AbstractTask task = this.builder.getItem();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)(task instanceof TaskTask));
        Assert.assertEquals((Object)"http://example.com-100", (Object)task.getHandleIdentifier());
        Assert.assertEquals((Object)"100", (Object)task.getTaskId());
        Assert.assertEquals((Object)"http://example.com", (Object)task.getRepositoryUrl());
        Assert.assertEquals((Object)"", (Object)task.getSummary());
        Assert.assertEquals((Object)ITask.PriorityLevel.P3.toString(), (Object)task.getPriority());
        Assert.assertNull((Object)task.getTaskKey());
    }

    @Test
    public void simpleTask() throws Exception {
        ImmutableMap.Builder attributesBuilder = ImmutableMap.builder();
        attributesBuilder.put((Object)"Handle", (Object)"1");
        attributesBuilder.put((Object)"TaskId", (Object)"100");
        attributesBuilder.put((Object)"RepositoryUrl", (Object)"http://example.com");
        attributesBuilder.put((Object)"Label", (Object)"Simple Task");
        attributesBuilder.put((Object)"Key", (Object)"EX-100");
        attributesBuilder.put((Object)"Priority", (Object)ITask.PriorityLevel.P1.toString());
        attributesBuilder.put((Object)"ConnectorKind", (Object)"connector.kind");
        this.builder.beginItem((Attributes)this.createAttributes((Map<String, String>)attributesBuilder.build()));
        Assert.assertTrue((boolean)this.builder.getErrors().isOK());
        AbstractTask task = this.builder.getItem();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)(task instanceof TaskTask));
        Assert.assertEquals((Object)"http://example.com-100", (Object)task.getHandleIdentifier());
        Assert.assertEquals((Object)"100", (Object)task.getTaskId());
        Assert.assertEquals((Object)"http://example.com", (Object)task.getRepositoryUrl());
        Assert.assertEquals((Object)"Simple Task", (Object)task.getSummary());
        Assert.assertEquals((Object)"EX-100", (Object)task.getTaskKey());
        Assert.assertEquals((Object)ITask.PriorityLevel.P1.toString(), (Object)task.getPriority());
    }

    @Test
    public void taskWithAttributes() throws Exception {
        AttributesImpl elementAttributes = this.createAttributes((Map<String, String>)ImmutableMap.of((Object)"Handle", (Object)"1", (Object)"TaskId", (Object)"100", (Object)"RepositoryUrl", (Object)"http://example.com", (Object)"ConnectorKind", (Object)"connector.kind"));
        this.builder.beginItem((Attributes)elementAttributes);
        this.putAttribute("att1", "value1");
        this.putAttribute("att2", "value2");
        Assert.assertTrue((boolean)this.builder.getErrors().isOK());
        AbstractTask task = this.builder.getItem();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)(task instanceof TaskTask));
        Assert.assertEquals((long)2L, (long)task.getAttributes().size());
        Assert.assertEquals((Object)"value1", (Object)task.getAttribute("att1"));
        Assert.assertEquals((Object)"value2", (Object)task.getAttribute("att2"));
    }

    @Test
    public void invalidConnectorKind() throws Exception {
        AttributesImpl elementAttributes = this.createAttributes((Map<String, String>)ImmutableMap.of((Object)"Handle", (Object)"1", (Object)"TaskId", (Object)"100", (Object)"RepositoryUrl", (Object)"http://example.com", (Object)"ConnectorKind", (Object)"invalid"));
        this.builder.beginItem((Attributes)elementAttributes);
        Assert.assertFalse((boolean)this.builder.getErrors().isOK());
    }

    @Test
    public void localTask() throws Exception {
        ImmutableMap.Builder attributesBuilder = ImmutableMap.builder();
        attributesBuilder.put((Object)"Handle", (Object)"1");
        attributesBuilder.put((Object)"TaskId", (Object)"100");
        attributesBuilder.put((Object)"RepositoryUrl", (Object)"local");
        attributesBuilder.put((Object)"Label", (Object)"Simple Task");
        attributesBuilder.put((Object)"Key", (Object)"EX-100");
        attributesBuilder.put((Object)"Priority", (Object)ITask.PriorityLevel.P1.toString());
        attributesBuilder.put((Object)"ConnectorKind", (Object)"local");
        this.builder.beginItem((Attributes)this.createAttributes((Map<String, String>)attributesBuilder.build()));
        Assert.assertTrue((boolean)this.builder.getErrors().isOK());
        AbstractTask task = this.builder.getItem();
        Assert.assertNotNull((Object)task);
        Assert.assertTrue((boolean)(task instanceof LocalTask));
        Assert.assertEquals((Object)"local-100", (Object)task.getHandleIdentifier());
        Assert.assertEquals((Object)"100", (Object)task.getTaskId());
        Assert.assertEquals((Object)"local", (Object)task.getRepositoryUrl());
        Assert.assertEquals((Object)"Simple Task", (Object)task.getSummary());
        Assert.assertEquals((Object)ITask.PriorityLevel.P1.toString(), (Object)task.getPriority());
        Assert.assertNull((Object)task.getTaskKey());
    }

    private void putAttribute(String key, String value) {
        this.builder.startAttribute((Attributes)this.createAttributes((Map<String, String>)ImmutableMap.of((Object)"Key", (Object)key)));
        this.builder.acceptAttributeValueContent(value.toCharArray(), 0, value.length());
        this.builder.endAttribute();
    }

    private AttributesImpl createAttributes(Map<String, String> attributes) {
        AttributesImpl xmlAttributes = new AttributesImpl();
        for (String key : attributes.keySet()) {
            xmlAttributes.addAttribute("", key, key, "", attributes.get(key));
        }
        return xmlAttributes;
    }
}

