/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.reviewdb.ApprovalCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApprovalTypes {
    protected List<ApprovalType> approvalTypes;
    protected List<ApprovalType> actionTypes;
    private transient Map<ApprovalCategory.Id, ApprovalType> byCategoryId;

    protected ApprovalTypes() {
    }

    public ApprovalTypes(List<ApprovalType> approvals, List<ApprovalType> actions) {
        this.approvalTypes = approvals;
        this.actionTypes = actions;
        this.byCategory();
    }

    public List<ApprovalType> getApprovalTypes() {
        return this.approvalTypes;
    }

    public List<ApprovalType> getActionTypes() {
        return this.actionTypes;
    }

    public ApprovalType getApprovalType(ApprovalCategory.Id id) {
        return this.byCategory().get(id);
    }

    public Set<ApprovalCategory.Id> getApprovalCategories() {
        return this.byCategory().keySet();
    }

    private Map<ApprovalCategory.Id, ApprovalType> byCategory() {
        if (this.byCategoryId == null) {
            this.byCategoryId = new HashMap<ApprovalCategory.Id, ApprovalType>();
            if (this.actionTypes != null) {
                for (ApprovalType t : this.actionTypes) {
                    this.byCategoryId.put(t.getCategory().getId(), t);
                }
            }
            if (this.approvalTypes != null) {
                for (ApprovalType t : this.approvalTypes) {
                    this.byCategoryId.put(t.getCategory().getId(), t);
                }
            }
        }
        return this.byCategoryId;
    }
}

