/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Calendar;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.PresentationFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class PresentationFilterTest {
    private static boolean filterHidden;
    private static boolean filterNonMatching;
    private static IPreferenceStore preferenceStore;
    private static PresentationFilter filter;

    @BeforeClass
    public static void recordSettings() {
        preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        filterHidden = preferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.filters.hidden");
        filterNonMatching = preferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.filters.nonmatching");
    }

    @AfterClass
    public static void resetSettings() {
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.hidden", filterHidden);
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching", filterNonMatching);
    }

    @Before
    public void setup() {
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.hidden", false);
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching", false);
        filter = new PresentationFilter();
    }

    @Test
    public void readSettings() {
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.hidden", true);
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching", false);
        filter.updateSettings();
        Assert.assertTrue((boolean)filter.isFilterHiddenQueries());
        Assert.assertFalse((boolean)filter.isFilterNonMatching());
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.hidden", false);
        preferenceStore.setValue("org.eclipse.mylyn.tasks.ui.filters.nonmatching", true);
        filter.updateSettings();
        Assert.assertFalse((boolean)filter.isFilterHiddenQueries());
        Assert.assertTrue((boolean)filter.isFilterNonMatching());
    }

    @Test
    public void filterHiddenQueries() {
        RepositoryQuery visible = new RepositoryQuery("kind", "visible");
        RepositoryQuery hidden = new RepositoryQuery("kind", "hidden");
        hidden.setAttribute("task.common.hidden", "true");
        Assert.assertTrue((boolean)filter.select(null, (Object)visible));
        Assert.assertTrue((boolean)filter.select(null, (Object)hidden));
        filter.setFilterHiddenQueries(true);
        Assert.assertTrue((boolean)filter.select(null, (Object)visible));
        Assert.assertFalse((boolean)filter.select(null, (Object)hidden));
    }

    @Test
    public void filterLocalTasks() {
        TaskCategory category = new TaskCategory("category");
        LocalTask task = new LocalTask("1", "task");
        LocalTask subTask = new LocalTask("2", "subtask");
        this.addChild((AbstractTaskContainer)task, (AbstractTask)subTask);
        this.addChild((AbstractTaskContainer)category, (AbstractTask)task);
        Assert.assertTrue((boolean)filter.select((Object)category, (Object)task));
        Assert.assertTrue((boolean)filter.select((Object)task, (Object)subTask));
        filter.setFilterNonMatching(true);
        Assert.assertTrue((boolean)filter.select((Object)category, (Object)task));
        Assert.assertTrue((boolean)filter.select((Object)task, (Object)subTask));
    }

    @Test
    public void filterSubTasksInQuery() {
        RepositoryQuery query = new RepositoryQuery("kind", "query");
        this.assertMatchingSubTask((AbstractTaskContainer)query, (AbstractTaskContainer)query, true, true);
    }

    @Test
    public void filterSubTasksInCategory() {
        TaskCategory category = new TaskCategory("category");
        this.assertMatchingSubTask((AbstractTaskContainer)category, (AbstractTaskContainer)category, true, true);
    }

    @Test
    public void filterScheduledSubTasks() {
        ScheduledTaskContainer schedule = new ScheduledTaskContainer((TaskActivityManager)Mockito.mock(TaskActivityManager.class), new DateRange(Calendar.getInstance()));
        RepositoryQuery query = new RepositoryQuery("kind", "query");
        this.assertMatchingSubTask((AbstractTaskContainer)query, (AbstractTaskContainer)schedule, true, false);
    }

    @Test
    public void filterSubTasksInStateContainers() {
        TaskScheduleContentProvider.StateTaskContainer schedule = (TaskScheduleContentProvider.StateTaskContainer)Mockito.mock(TaskScheduleContentProvider.StateTaskContainer.class);
        RepositoryQuery query = new RepositoryQuery("kind", "query");
        this.assertMatchingSubTask((AbstractTaskContainer)query, (AbstractTaskContainer)schedule, false, false);
    }

    private void assertMatchingSubTask(AbstractTaskContainer taskContainer, AbstractTaskContainer subTaskContainer, boolean subTasksVisibleInContainer, boolean subTaskVisibleInTask) {
        TaskTask task = new TaskTask("kind", "http://eclipse.org", "task");
        TaskTask subTask = new TaskTask("kind", "http://eclipse.org", "subTask");
        TaskTask matchingSubTask = new TaskTask("kind", "http://eclipse.org", "matchingSubTask");
        this.addChild((AbstractTaskContainer)task, (AbstractTask)subTask);
        this.addChild((AbstractTaskContainer)task, (AbstractTask)matchingSubTask);
        this.addChild(taskContainer, (AbstractTask)task);
        this.addChild(subTaskContainer, (AbstractTask)matchingSubTask);
        Assert.assertTrue((boolean)filter.select((Object)taskContainer, (Object)task));
        Assert.assertTrue((boolean)filter.select((Object)task, (Object)subTask));
        Assert.assertTrue((boolean)filter.select((Object)task, (Object)matchingSubTask));
        Assert.assertTrue((boolean)filter.select((Object)subTaskContainer, (Object)matchingSubTask));
        filter.setFilterNonMatching(true);
        Assert.assertTrue((boolean)filter.select((Object)taskContainer, (Object)task));
        Assert.assertFalse((boolean)filter.select((Object)task, (Object)subTask));
        Assert.assertEquals((Object)subTaskVisibleInTask, (Object)filter.select((Object)task, (Object)matchingSubTask));
        Assert.assertEquals((Object)subTasksVisibleInContainer, (Object)filter.select((Object)subTaskContainer, (Object)matchingSubTask));
    }

    private void addChild(AbstractTaskContainer container, AbstractTask task) {
        container.internalAddChild(task);
        task.getParentContainers().add(container);
    }
}

