/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.ui.ClipboardCopier;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CopyTaskDetailsAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.copy";
    private Mode mode;

    public CopyTaskDetailsAction(Mode mode) {
        super("");
        this.setMode(mode);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
        this.setText(mode.message);
    }

    public void run() {
        ClipboardCopier.getDefault().copy(this.getStructuredSelection(), new ClipboardCopier.TextProvider(){

            public String getTextForElement(Object element) {
                return CopyTaskDetailsAction.getTextForTask(element, CopyTaskDetailsAction.this.getMode());
            }
        });
    }

    public static String getTextForTask(Object object) {
        return CopyTaskDetailsAction.getTextForTask(object, Mode.ID_SUMMARY_URL);
    }

    public static String getTextForTask(Object object, Mode mode) {
        StringBuffer sb = new StringBuffer();
        switch (mode) {
            case KEY: {
                ITask task;
                if (!(object instanceof ITask) || (task = (ITask)object).getTaskKey() == null) break;
                sb.append(task.getTaskKey());
                break;
            }
            case URL: {
                String taskUrl;
                if (!(object instanceof IRepositoryElement) || !TasksUiInternal.isValidUrl(taskUrl = CopyTaskDetailsAction.getUrl((IRepositoryElement)object))) break;
                sb.append(taskUrl);
                break;
            }
            case ID_SUMMARY: {
                if (object instanceof ITask) {
                    ITask task = (ITask)object;
                    if (task.getTaskKey() != null) {
                        sb.append(StringUtils.capitalize((String)TasksUiInternal.getTaskPrefix(task.getConnectorKind())));
                        sb.append(task.getTaskKey());
                        sb.append(": ");
                    }
                    sb.append(task.getSummary());
                    break;
                }
                if (!(object instanceof IRepositoryElement)) break;
                IRepositoryElement element = (IRepositoryElement)object;
                sb.append(element.getSummary());
                break;
            }
            case ID_SUMMARY_URL: {
                if (object instanceof ITask) {
                    ITask task = (ITask)object;
                    if (task.getTaskKey() != null) {
                        sb.append(task.getTaskKey());
                        sb.append(": ");
                    }
                    sb.append(task.getSummary());
                    String taskUrl = CopyTaskDetailsAction.getUrl((IRepositoryElement)object);
                    if (!TasksUiInternal.isValidUrl(taskUrl)) break;
                    sb.append(ClipboardCopier.LINE_SEPARATOR);
                    sb.append(taskUrl);
                    break;
                }
                if (object instanceof IRepositoryQuery) {
                    RepositoryQuery query = (RepositoryQuery)object;
                    sb.append(query.getSummary());
                    if (!TasksUiInternal.isValidUrl(query.getUrl())) break;
                    sb.append(ClipboardCopier.LINE_SEPARATOR);
                    sb.append(query.getUrl());
                    break;
                }
                if (!(object instanceof IRepositoryElement)) break;
                IRepositoryElement element = (IRepositoryElement)object;
                sb.append(element.getSummary());
            }
        }
        return sb.toString();
    }

    private static String getUrl(IRepositoryElement element) {
        if (element instanceof ITask) {
            TaskRepository repository;
            ITask task = (ITask)element;
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(task.getConnectorKind());
            URL location = connector.getBrowserUrl(repository = TasksUiInternal.getRepository((IRepositoryElement)task), element);
            if (location != null) {
                return location.toString();
            }
            if (task.getUrl() != null) {
                return task.getUrl();
            }
            return connector.getTaskUrl(task.getRepositoryUrl(), task.getTaskId());
        }
        if (element.getUrl() != null) {
            return element.getUrl();
        }
        return null;
    }

    public static enum Mode {
        KEY(Messages.CopyTaskDetailsAction_ID_Menu_Label),
        URL(Messages.CopyTaskDetailsAction_Url_Menu_Label),
        ID_SUMMARY(Messages.CopyTaskDetailsAction_ID_Summary_Menu_Label),
        ID_SUMMARY_URL(Messages.CopyTaskDetailsAction_ID_Summary_and_Url_Menu_Label);

        @Deprecated
        public static Mode SUMMARY;
        @Deprecated
        public static Mode SUMMARY_URL;
        private String message;

        static {
            SUMMARY = ID_SUMMARY;
            SUMMARY_URL = ID_SUMMARY_URL;
        }

        private Mode(String message) {
            this.message = message;
        }
    }
}

