/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritService;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;

public class GerritRestClient {
    protected static final String GET_LABELS_OPTION = "LABELS";
    protected static final String GET_DETAILED_ACCOUNTS_OPTION = "DETAILED_ACCOUNTS";
    private final GerritHttpClient client;

    public GerritRestClient(GerritHttpClient client) {
        this.client = client;
    }

    private static boolean isAuthenticationException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Invalid xsrfKey in request".equals(((GerritException)exception).getMessage());
        }
        return false;
    }

    protected <T> T execute(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        try {
            T t;
            GerritService.GerritRequest.setCurrentRequest(new GerritService.GerritRequest(monitor));
            try {
                t = this.executeOnce(monitor, operation);
            }
            catch (GerritException e) {
                block7: {
                    if (!GerritRestClient.isAuthenticationException(e)) break block7;
                    operation.reset();
                    T t2 = this.executeOnce(monitor, operation);
                    GerritService.GerritRequest.setCurrentRequest(null);
                    return t2;
                }
                throw e;
            }
            return t;
        }
        finally {
            GerritService.GerritRequest.setCurrentRequest(null);
        }
    }

    protected <T> T executePostRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(GerritRestClient.this.client.postRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    protected <T> T executeGetRestRequest(final String url, final Type resultType, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(GerritRestClient.this.client.getRestRequest(url, resultType, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    protected <T> T executePutRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(GerritRestClient.this.client.putRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    public <T> T executeDeleteRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this.client){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(GerritRestClient.this.client.deleteRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    private <T> T executeOnce(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        operation.execute(monitor);
        if (operation.getException() instanceof GerritException) {
            throw (GerritException)operation.getException();
        }
        if (operation.getException() instanceof OperationCanceledException) {
            throw (OperationCanceledException)operation.getException();
        }
        if (operation.getException() instanceof RuntimeException) {
            throw (RuntimeException)operation.getException();
        }
        if (operation.getException() != null) {
            GerritException e = new GerritException();
            e.initCause(operation.getException());
            throw e;
        }
        return operation.getResult();
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, String queryString) throws GerritException {
        return this.executeQuery(monitor, queryString, (List<String>)ImmutableList.of((Object)GET_LABELS_OPTION, (Object)GET_DETAILED_ACCOUNTS_OPTION));
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, String queryString, List<String> optionsList) throws GerritException {
        String uri = "/changes/?q=" + GerritClient.encode(queryString);
        if (optionsList != null && !optionsList.isEmpty()) {
            for (String option : optionsList) {
                if (!StringUtils.isNotBlank((String)option)) continue;
                uri = String.valueOf(uri) + "&o=" + GerritClient.encode(option);
            }
        }
        TypeToken<List<GerritQueryResult>> queryResultListType = new TypeToken<List<GerritQueryResult>>(){};
        return (List)this.executeGetRestRequest(uri, queryResultListType.getType(), monitor);
    }

    public List<GerritQueryResult> queryAllReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "status:open");
    }

    public List<GerritQueryResult> queryByProject(IProgressMonitor monitor, String project) throws GerritException {
        return this.executeQuery(monitor, "status:open project:" + project);
    }

    public List<GerritQueryResult> queryMyReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "owner:self OR reviewer:self");
    }

    public List<GerritQueryResult> queryWatchedReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "is:watched status:open");
    }

    static abstract class Operation<T>
    implements AsyncCallback<T> {
        private Throwable exception;
        private T result;
        private final GerritHttpClient client;

        public abstract void execute(IProgressMonitor var1) throws GerritException;

        public Operation(GerritHttpClient client) {
            this.client = client;
        }

        public Throwable getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }

        public void onFailure(Throwable exception) {
            if (GerritRestClient.isAuthenticationException(exception)) {
                this.client.setXsrfCookie(null);
            }
            this.exception = exception;
        }

        public void onSuccess(T result) {
            this.setResult(result);
        }

        protected void setResult(T result) {
            this.result = result;
        }

        public void reset() {
            this.result = null;
            this.exception = null;
        }
    }
}

