/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;

public class PresentationFilter
extends AbstractTaskListFilter {
    private static PresentationFilter instance = new PresentationFilter();
    private boolean filterHiddenQueries;
    private boolean filterNonMatching;

    public static PresentationFilter getInstance() {
        return instance;
    }

    PresentationFilter() {
        this.updateSettings();
    }

    public boolean isFilterHiddenQueries() {
        return this.filterHiddenQueries;
    }

    public boolean isFilterNonMatching() {
        return this.filterNonMatching;
    }

    @Override
    public boolean select(Object parent, Object element) {
        if (element instanceof IRepositoryQuery) {
            return this.selectQuery((IRepositoryQuery)element);
        }
        if (element instanceof TaskTask) {
            return this.selectTask(parent, (TaskTask)element);
        }
        return true;
    }

    private boolean selectQuery(IRepositoryQuery query) {
        if (!this.filterHiddenQueries) {
            return true;
        }
        return !Boolean.parseBoolean(query.getAttribute("task.common.hidden"));
    }

    private boolean selectTask(Object parent, TaskTask task) {
        if (!this.filterNonMatching) {
            return true;
        }
        if (this.isInVisibleQuery((ITask)task)) {
            return true;
        }
        return parent != null && parent.getClass().equals(ScheduledTaskContainer.class);
    }

    public void setFilterHiddenQueries(boolean enabled) {
        this.filterHiddenQueries = enabled;
    }

    public void setFilterNonMatching(boolean filterSubtasks) {
        this.filterNonMatching = filterSubtasks;
    }

    public void updateSettings() {
        this.setFilterHiddenQueries(TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.hidden"));
        this.setFilterNonMatching(TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.nonmatching"));
    }

    public boolean isInVisibleQuery(ITask task) {
        for (AbstractTaskContainer container : ((AbstractTask)task).getParentContainers()) {
            if (container instanceof AbstractTaskCategory) {
                return true;
            }
            if (!(container instanceof IRepositoryQuery) || !this.selectQuery((IRepositoryQuery)container)) continue;
            return true;
        }
        return false;
    }
}

