/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataExternalizer;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.SAXException;

public class TaskDataStoreTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final int THREAD_COUNT = 10;
    private static final long DELAY = 100L;
    private static final String DATA_XML_CONTENT = "test";
    private static final TaskData TASK_DATA = TaskDataStoreTest.newTaskData();
    private static final TaskDataState TEST_STATE = new TaskDataState("connectorKind", "repositoryUrl", "taskId");

    @Test
    public void getTaskDataStateByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.getTaskDataState(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void discardEditsByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.discardEdits(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void putEditsByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.putEdits(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void putTaskDataSetLastReadUserByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.putTaskData(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void setTaskDataByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.setTaskData(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void putTaskDataByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.putTaskDataState(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void deleteTaskDataByMultipleThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        List<Throwable> failures = TaskDataStoreTest.runSameByMultipleThreads(this.deleteTaskData(file));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    @Test
    public void manipulateTaskDataConcurrently() throws Exception {
        File file = this.newTaskDataZipFile();
        int i = 0;
        while (i <= 10) {
            List<Throwable> failures = TaskDataStoreTest.runConcurrently(this.getTaskDataState(file), this.discardEdits(file), this.putEdits(file), this.putTaskData(file), this.setTaskData(file), this.putTaskDataState(file), this.deleteTaskData(file));
            TaskDataStoreTest.assertNoFailures(failures);
            ++i;
        }
    }

    @Test
    public void manipulateTaskDataByFixedNumberOfThreads() throws Exception {
        File file = this.newTaskDataZipFile();
        TaskDataStore store = TaskDataStoreTest.newTaskDataStore();
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.getTaskDataState(file), store, Optional.empty(), failures).get()));
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.discardEdits(file), store, Optional.empty(), failures).get()));
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.putEdits(file), store, Optional.empty(), failures).get()));
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.putTaskData(file), store, Optional.empty(), failures).get()));
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.setTaskData(file), store, Optional.empty(), failures).get()));
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.putTaskDataState(file), store, Optional.empty(), failures).get()));
        threads.addAll(Collections.nCopies(3, TaskDataStoreTest.thread(this.deleteTaskData(file), store, Optional.empty(), failures).get()));
        Collections.shuffle(threads);
        threads.stream().forEach(thread -> {
            Future<?> future = executor.submit((Runnable)thread);
        });
        executor.shutdown();
        Assert.assertTrue((boolean)executor.awaitTermination(30L, TimeUnit.SECONDS));
        TaskDataStoreTest.assertNoFailures(failures);
    }

    private static TaskDataStore newTaskDataStore() {
        TaskRepositoryManager manager = new TaskRepositoryManager();
        TaskDataExternalizer externalizer = new TaskDataExternalizer((IRepositoryManager)manager){

            public TaskDataState readState(InputStream in) throws IOException, SAXException {
                Assert.assertEquals((Object)TaskDataStoreTest.DATA_XML_CONTENT, (Object)new String(ByteStreams.toByteArray((InputStream)in), Charsets.UTF_8));
                in.close();
                TaskDataStoreTest.sleep();
                return TEST_STATE;
            }

            public void writeState(OutputStream out, ITaskDataWorkingCopy state) throws IOException {
                out.write(TaskDataStoreTest.DATA_XML_CONTENT.getBytes(Charsets.UTF_8));
                TaskDataStoreTest.sleep();
            }
        };
        return new TaskDataStore(externalizer);
    }

    private static void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private File newTaskDataZipFile() throws IOException {
        File file = this.folder.newFile("test.zip");
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(file));){
            ZipEntry entry = new ZipEntry("data.xml");
            outputStream.putNextEntry(entry);
            byte[] data = DATA_XML_CONTENT.getBytes();
            outputStream.write(data, 0, data.length);
            outputStream.closeEntry();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    private static TaskData newTaskData() {
        TaskRepository repository = new TaskRepository("connectorKind", "repositoryUrl");
        TaskAttributeMapper mapper = new TaskAttributeMapper(repository);
        return new TaskData(mapper, "connectorKind", "repositoryUrl", "taskId");
    }

    private ConsumerWithCoreException<TaskDataStore> getTaskDataState(File file) {
        return store -> {
            TaskDataState taskDataState = store.getTaskDataState(file);
        };
    }

    private ConsumerWithCoreException<TaskDataStore> discardEdits(File file) {
        return store -> {
            TaskDataState taskDataState = store.discardEdits(file);
        };
    }

    private ConsumerWithCoreException<TaskDataStore> putEdits(File file) {
        return store -> store.putEdits(file, TASK_DATA);
    }

    private ConsumerWithCoreException<TaskDataStore> putTaskData(File file) {
        return store -> {
            TaskDataState taskDataState = store.putTaskData(file, TASK_DATA, true, true);
        };
    }

    private ConsumerWithCoreException<TaskDataStore> setTaskData(File file) {
        return store -> {
            TaskDataState taskDataState = store.setTaskData(file, TASK_DATA);
        };
    }

    private ConsumerWithCoreException<TaskDataStore> putTaskDataState(File file) {
        return store -> store.putTaskData(file, TEST_STATE);
    }

    private ConsumerWithCoreException<TaskDataStore> deleteTaskData(File file) {
        return store -> {
            boolean bl = store.deleteTaskData(file);
        };
    }

    private static List<Throwable> runSameByMultipleThreads(ConsumerWithCoreException<TaskDataStore> consumer) throws Exception {
        TaskDataStore store = TaskDataStoreTest.newTaskDataStore();
        CyclicBarrier barrier = new CyclicBarrier(11);
        ArrayList<Throwable> failures = new ArrayList<Throwable>(10);
        List<Thread> threads = Stream.generate(TaskDataStoreTest.thread(consumer, store, Optional.of(barrier), failures)).limit(10L).collect(Collectors.toList());
        TaskDataStoreTest.startThreadsSimultaneously(barrier, threads);
        return failures;
    }

    @SafeVarargs
    private static List<Throwable> runConcurrently(ConsumerWithCoreException<TaskDataStore> ... consumers) throws Exception {
        TaskDataStore store = TaskDataStoreTest.newTaskDataStore();
        CyclicBarrier barrier = new CyclicBarrier(consumers.length + 1);
        ArrayList<Throwable> failures = new ArrayList<Throwable>(consumers.length);
        List<Thread> threads = Arrays.asList(consumers).stream().map(c -> TaskDataStoreTest.thread(c, store, Optional.of(barrier), failures).get()).collect(Collectors.toList());
        TaskDataStoreTest.startThreadsSimultaneously(barrier, threads);
        return failures;
    }

    private static void startThreadsSimultaneously(CyclicBarrier barrier, List<Thread> threads) throws Exception {
        threads.stream().forEach(Thread::start);
        barrier.await();
        for (Thread thread : threads) {
            thread.join();
        }
    }

    private static Supplier<Thread> thread(final ConsumerWithCoreException<TaskDataStore> consumer, final TaskDataStore store, final Optional<CyclicBarrier> barrier, final List<Throwable> failures) {
        return new Supplier<Thread>(){

            @Override
            public Thread get() {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            barrier.ifPresent(b -> {
                                try {
                                    b.await();
                                }
                                catch (InterruptedException | BrokenBarrierException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                            consumer.accept(store);
                        }
                        catch (Throwable e) {
                            failures.add(e);
                        }
                    }
                });
            }
        };
    }

    private static void assertNoFailures(List<Throwable> failures) {
        Assert.assertTrue((String)String.format("expected no failures but found %d:\n%s", failures.size(), TaskDataStoreTest.collectMessages(failures)), (boolean)failures.isEmpty());
    }

    private static String collectMessages(List<Throwable> failures) {
        return failures.stream().map(e -> e.getClass().getSimpleName()).collect(Collectors.joining("\n"));
    }

    @FunctionalInterface
    public static interface ConsumerWithCoreException<T> {
        public void accept(T var1) throws CoreException;
    }
}

