/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.tests;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.index.core.TaskListIndex;
import org.eclipse.mylyn.internal.tasks.index.tests.AbstractTaskListIndexTest;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.DefaultTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.junit.Assert;
import org.junit.Test;

public class TaskListIndexTest
extends AbstractTaskListIndexTest {
    private static final AbstractTaskSchema.Field FIELD_SUMMARY = DefaultTaskSchema.getInstance().SUMMARY;
    private static final AbstractTaskSchema.Field FIELD_DATE_CREATION = DefaultTaskSchema.getInstance().DATE_CREATION;

    @Test
    public void testMatchesLocalTaskOnSummary() throws InterruptedException {
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        Assert.assertTrue((boolean)this.index.matches(task, task.getSummary()));
        Assert.assertFalse((boolean)this.index.matches(task, "" + System.currentTimeMillis()));
        this.index.setDefaultField(FIELD_SUMMARY);
        Assert.assertTrue((boolean)this.index.matches(task, task.getSummary()));
        Assert.assertFalse((boolean)this.index.matches(task, "" + System.currentTimeMillis()));
    }

    @Test
    public void testMatchesLocalTaskOnDescription() throws InterruptedException {
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        Assert.assertTrue((boolean)this.index.matches(task, ((LocalTask)task).getNotes()));
        Assert.assertFalse((boolean)this.index.matches(task, "unlikely-akjfsaow"));
        this.index.setDefaultField(FIELD_SUMMARY);
        Assert.assertFalse((boolean)this.index.matches(task, ((LocalTask)task).getNotes()));
    }

    @Test
    public void testMatchesRepositoryTaskOnSummary() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createRepositoryTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        String summary = task.getSummary();
        Assert.assertTrue((boolean)this.index.matches(task, summary));
        Assert.assertTrue((boolean)this.index.matches(task, String.valueOf(summary.substring(0, summary.length() - 3)) + "*"));
        Assert.assertFalse((boolean)this.index.matches(task, "" + System.currentTimeMillis()));
        this.index.setDefaultField(FIELD_SUMMARY);
        Assert.assertTrue((boolean)this.index.matches(task, summary));
        Assert.assertTrue((boolean)this.index.matches(task, String.valueOf(summary.substring(0, summary.length() - 3)) + "*"));
        Assert.assertFalse((boolean)this.index.matches(task, "" + System.currentTimeMillis()));
    }

    @Test
    public void testMatchesRepositoryTaskOnDescription() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createRepositoryTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        TaskData taskData = this.context.getDataManager().getTaskData(task);
        Assert.assertNotNull((Object)taskData);
        TaskMapper taskMapping = this.context.getMockRepositoryConnector().getTaskMapping(taskData);
        Assert.assertTrue((boolean)this.index.matches(task, taskMapping.getDescription()));
        Assert.assertFalse((boolean)this.index.matches(task, "unlikely-akjfsaow"));
        this.index.setDefaultField(FIELD_SUMMARY);
        Assert.assertFalse((boolean)this.index.matches(task, taskMapping.getDescription()));
    }

    @Test
    public void testFind() throws InterruptedException {
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(FIELD_SUMMARY);
        this.assertCanFindTask(task);
    }

    @Test
    public void testMatchesRepositoryTaskOnCreationDate() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createRepositoryTask();
        Date creationDate = task.getCreationDate();
        Assert.assertNotNull((Object)creationDate);
        this.index.waitUntilIdle();
        Assert.assertFalse((boolean)this.index.matches(task, String.valueOf(FIELD_DATE_CREATION.getIndexKey()) + ":[20010101 TO 20010105]"));
        String matchDate = new SimpleDateFormat("yyyyMMdd").format(creationDate);
        matchDate = Integer.toString(Integer.parseInt(matchDate) + 2);
        String patternString = String.valueOf(FIELD_DATE_CREATION.getIndexKey()) + ":[20111019 TO " + matchDate + "]";
        System.out.println(patternString);
        Assert.assertTrue((boolean)this.index.matches(task, patternString));
    }

    @Test
    public void testMatchesOnRepositoryUrl() throws Exception {
        this.setupIndex();
        ITask repositoryTask = this.context.createRepositoryTask();
        ITask localTask = this.context.createLocalTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        TaskData taskData = this.context.getDataManager().getTaskData(repositoryTask);
        Assert.assertNotNull((Object)taskData);
        Assert.assertNotNull((Object)taskData.getRepositoryUrl());
        Assert.assertFalse((taskData.getRepositoryUrl().length() == 0 ? 1 : 0) != 0);
        String content = "RepositoryUrl";
        taskData.getRoot().getMappedAttribute("task.common.description").setValue("RepositoryUrl");
        ((AbstractTask)localTask).setNotes("RepositoryUrl");
        this.context.getDataManager().putSubmittedTaskData(repositoryTask, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        HashSet<ITask> changedElements = new HashSet<ITask>();
        changedElements.add(localTask);
        changedElements.add(repositoryTask);
        this.context.getTaskList().notifyElementsChanged(changedElements);
        this.index.waitUntilIdle();
        Assert.assertTrue((boolean)this.index.matches(localTask, "RepositoryUrl"));
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, "RepositoryUrl"));
        String repositoryUrlQuery = "RepositoryUrl AND " + TaskListIndex.FIELD_REPOSITORY_URL.getIndexKey() + ":\"" + this.index.escapeFieldValue(repositoryTask.getRepositoryUrl()) + "\"";
        Assert.assertFalse((boolean)this.index.matches(localTask, repositoryUrlQuery));
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, repositoryUrlQuery));
    }

    @Test
    public void testMatchesOnTaskKey() throws Exception {
        this.setupIndex();
        ITask repositoryTask = this.context.createRepositoryTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        TaskData taskData = this.context.getDataManager().getTaskData(repositoryTask);
        Assert.assertNotNull((Object)taskData);
        Assert.assertNotNull((Object)taskData.getRoot().getMappedAttribute("task.common.key"));
        String taskKey = repositoryTask.getTaskKey();
        Assert.assertTrue((taskKey.length() > 1 ? 1 : 0) != 0);
        String querySuffix = " AND " + TaskListIndex.FIELD_CONTENT.getIndexKey() + ":\"" + this.index.escapeFieldValue(taskData.getRoot().getMappedAttribute("task.common.summary").getValue()) + "\"";
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, String.valueOf(TaskListIndex.FIELD_TASK_KEY.getIndexKey()) + ":" + taskKey + querySuffix));
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, String.valueOf(TaskListIndex.FIELD_TASK_KEY.getIndexKey()) + ":" + taskKey.substring(0, taskKey.length() - 1) + querySuffix));
    }

    @Test
    public void testMatchesSummaryWithExpectedQueryBehaviour() throws InterruptedException {
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        task.setSummary("one two three");
        this.context.getTaskList().notifyElementsChanged(Collections.singleton(task));
        this.index.waitUntilIdle();
        this.index.setDefaultField(FIELD_SUMMARY);
        Assert.assertTrue((boolean)this.index.matches(task, "one"));
        Assert.assertTrue((boolean)this.index.matches(task, "two"));
        Assert.assertTrue((boolean)this.index.matches(task, "three"));
        Assert.assertTrue((boolean)this.index.matches(task, "thr"));
        Assert.assertFalse((boolean)this.index.matches(task, "one three"));
        Assert.assertFalse((boolean)this.index.matches(task, "one*three"));
        Assert.assertTrue((boolean)this.index.matches(task, "t*ee"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one OR three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND thr"));
        Assert.assertFalse((boolean)this.index.matches(task, "one AND four"));
    }

    @Test
    public void testMatchesNotesWithExpectedQueryBehaviourWithRepositoryTask() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createRepositoryTask();
        ((AbstractTask)task).setNotes("one two three");
        this.index.reindex();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_NOTES);
        Assert.assertFalse((boolean)this.index.matches(task, "asdf"));
        Assert.assertTrue((boolean)this.index.matches(task, "one"));
        Assert.assertTrue((boolean)this.index.matches(task, "two"));
        Assert.assertTrue((boolean)this.index.matches(task, "three"));
        Assert.assertTrue((boolean)this.index.matches(task, "thr"));
        Assert.assertTrue((boolean)this.index.matches(task, "one two"));
        Assert.assertTrue((boolean)this.index.matches(task, "one three"));
        Assert.assertFalse((boolean)this.index.matches(task, "one*three"));
        Assert.assertTrue((boolean)this.index.matches(task, "t*ee"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one OR three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND thr"));
        Assert.assertFalse((boolean)this.index.matches(task, "one AND four"));
    }

    @Test
    public void testMatchesNotesWithExpectedQueryBehaviourWithLocalTask() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        ((AbstractTask)task).setNotes("one two three");
        this.context.getTaskList().notifyElementsChanged(Collections.singleton(task));
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_NOTES);
        Assert.assertFalse((boolean)this.index.matches(task, "asdf"));
        Assert.assertTrue((boolean)this.index.matches(task, "one"));
        Assert.assertTrue((boolean)this.index.matches(task, "two"));
        Assert.assertTrue((boolean)this.index.matches(task, "three"));
        Assert.assertTrue((boolean)this.index.matches(task, "thr"));
        Assert.assertTrue((boolean)this.index.matches(task, "one two"));
        Assert.assertTrue((boolean)this.index.matches(task, "one three"));
        Assert.assertFalse((boolean)this.index.matches(task, "one*three"));
        Assert.assertTrue((boolean)this.index.matches(task, "t*ee"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one OR three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND thr"));
        Assert.assertFalse((boolean)this.index.matches(task, "one AND four"));
    }

    @Test
    public void testMatchesContentWithExpectedQueryBehaviourWithRepositoryTask() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createRepositoryTask();
        ((AbstractTask)task).setNotes("one two three");
        this.index.reindex();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        Assert.assertFalse((boolean)this.index.matches(task, "asdf"));
        Assert.assertTrue((boolean)this.index.matches(task, "one"));
        Assert.assertTrue((boolean)this.index.matches(task, "two"));
        Assert.assertTrue((boolean)this.index.matches(task, "three"));
        Assert.assertTrue((boolean)this.index.matches(task, "thr"));
        Assert.assertTrue((boolean)this.index.matches(task, "one two"));
        Assert.assertTrue((boolean)this.index.matches(task, "one three"));
        Assert.assertFalse((boolean)this.index.matches(task, "one*three"));
        Assert.assertTrue((boolean)this.index.matches(task, "t*ee"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one OR three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND thr"));
        Assert.assertFalse((boolean)this.index.matches(task, "one AND four"));
    }

    @Test
    public void testMatchesContentWithExpectedQueryBehaviourWithLocalTask() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask task = this.context.createLocalTask();
        ((AbstractTask)task).setNotes("one two three");
        this.context.getTaskList().notifyElementsChanged(Collections.singleton(task));
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        Assert.assertFalse((boolean)this.index.matches(task, "asdf"));
        Assert.assertTrue((boolean)this.index.matches(task, "one"));
        Assert.assertTrue((boolean)this.index.matches(task, "two"));
        Assert.assertTrue((boolean)this.index.matches(task, "three"));
        Assert.assertTrue((boolean)this.index.matches(task, "thr"));
        Assert.assertTrue((boolean)this.index.matches(task, "one two"));
        Assert.assertTrue((boolean)this.index.matches(task, "one three"));
        Assert.assertFalse((boolean)this.index.matches(task, "one*three"));
        Assert.assertTrue((boolean)this.index.matches(task, "t*ee"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one OR three"));
        Assert.assertTrue((boolean)this.index.matches(task, "one AND thr"));
        Assert.assertFalse((boolean)this.index.matches(task, "one AND four"));
    }

    @Test
    public void testCharacterEscaping() {
        this.setupIndex();
        String[] stringArray = new String[]{"+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String special = stringArray[n2];
            Assert.assertEquals((Object)("a\\" + special + "b"), (Object)this.index.escapeFieldValue("a" + special + "b"));
            ++n2;
        }
    }

    @Test
    public void testAttributeMetadataAffectsIndexing() throws CoreException, InterruptedException {
        this.setupIndex();
        ITask repositoryTask = this.context.createRepositoryTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        TaskData taskData = this.context.getDataManager().getTaskData(repositoryTask);
        Assert.assertNotNull((Object)taskData);
        String content = "c" + System.currentTimeMillis();
        TaskAttribute attribute = taskData.getRoot().createAttribute("unusualIndexedAttribute");
        attribute.setValue(content);
        this.context.getDataManager().putSubmittedTaskData(repositoryTask, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        Assert.assertFalse((boolean)this.index.matches(repositoryTask, content));
        attribute.getMetaData().putValue("task.meta.index.content", "true");
        this.context.getDataManager().putSubmittedTaskData(repositoryTask, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, content));
    }

    @Test
    public void testMultithreadedAccessOnFind() throws CoreException, InterruptedException, ExecutionException {
        this.setupIndex();
        final ITask repositoryTask = this.context.createRepositoryTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        int nThreads = 10;
        final int[] concurrencyLevel = new int[1];
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        try {
            HashSet<1> tasks = new HashSet<1>();
            int x = 0;
            while (x < 10) {
                tasks.add(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        final int[] hitCount = new int[1];
                        TaskListIndexTest.this.index.find(repositoryTask.getSummary(), new TaskListIndex.TaskCollector(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void collect(ITask task) {
                                int[] nArray = concurrencyLevel;
                                synchronized (concurrencyLevel) {
                                    concurrencyLevel[0] = concurrencyLevel[0] + 1;
                                    if (concurrencyLevel[0] < 10) {
                                        try {
                                            concurrencyLevel.wait(5000L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        concurrencyLevel.notifyAll();
                                    }
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    hitCount[0] = hitCount[0] + 1;
                                    return;
                                }
                            }
                        }, 100);
                        if (hitCount[0] == 1) {
                            return true;
                        }
                        return false;
                    }
                });
                ++x;
            }
            List futures = executorService.invokeAll(tasks);
            for (Future future : futures) {
                Assert.assertEquals((Object)Boolean.TRUE, future.get());
            }
            Assert.assertEquals((long)10L, (long)concurrencyLevel[0]);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    public void testRepositoryUrlChanged() throws InterruptedException, CoreException {
        this.setupIndex();
        ITask repositoryTask = this.context.createRepositoryTask();
        String originalHandle = repositoryTask.getHandleIdentifier();
        this.index.waitUntilIdle();
        String newUrl = String.valueOf(this.context.getMockRepository().getRepositoryUrl()) + "/changed";
        this.context.refactorMockRepositoryUrl(newUrl);
        Assert.assertFalse((boolean)originalHandle.equals(repositoryTask.getHandleIdentifier()));
        this.index.waitUntilIdle();
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, String.valueOf(TaskListIndex.FIELD_IDENTIFIER.getIndexKey()) + ":" + this.index.escapeFieldValue(repositoryTask.getHandleIdentifier())));
    }

    @Test
    public void testSetLocation() throws InterruptedException, IOException {
        this.setupIndex();
        this.index.setDefaultField(FIELD_SUMMARY);
        ITask task = this.context.createLocalTask();
        this.index.waitUntilIdle();
        this.assertCanFindTask(task);
        File newLocation = CommonTestUtil.createTempFolder((String)TaskListIndexTest.class.getSimpleName());
        try {
            Assert.assertEquals((long)0L, (long)newLocation.list().length);
            this.index.setLocation(newLocation);
            this.index.waitUntilIdle();
            this.assertCanFindTask(task);
            Assert.assertFalse((newLocation.list().length == 0 ? 1 : 0) != 0);
        }
        finally {
            this.disposeIndex();
            CommonTestUtil.deleteFolderRecursively((File)newLocation);
            Assert.assertFalse((boolean)newLocation.exists());
        }
    }

    @Test
    public void testFindByTaskAttachmentName() throws CoreException, InterruptedException {
        this.setupIndex();
        ITask repositoryTask = this.context.createRepositoryTask();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        TaskData taskData = this.context.getDataManager().getTaskData(repositoryTask);
        TaskAttribute attachmentAttribute = taskData.getRoot().createAttribute("attachment-0");
        attachmentAttribute.getMetaData().setType("attachment");
        TaskAttachmentMapper attachmentMapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
        attachmentMapper.setFileName("test-file.txt");
        attachmentMapper.setDescription("test file " + System.currentTimeMillis());
        attachmentMapper.applyTo(attachmentAttribute);
        this.context.getDataManager().putSubmittedTaskData(repositoryTask, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        this.context.getTaskList().notifyElementsChanged(Collections.singleton(repositoryTask));
        this.index.waitUntilIdle();
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, "\"" + attachmentMapper.getDescription() + "\""));
        Assert.assertTrue((boolean)this.index.matches(repositoryTask, String.valueOf(TaskListIndex.FIELD_ATTACHMENT_NAME.getIndexKey()) + ":\"" + attachmentMapper.getFileName() + "\""));
        Assert.assertFalse((boolean)this.index.matches(repositoryTask, String.valueOf(TaskListIndex.FIELD_CONTENT.getIndexKey()) + ":\"" + attachmentMapper.getFileName() + "\""));
        Assert.assertFalse((boolean)this.index.matches(repositoryTask, String.valueOf(TaskListIndex.FIELD_ATTACHMENT_NAME.getIndexKey()) + ":\"" + attachmentMapper.getDescription() + "\""));
    }

    @Test
    public void testFindWithComplexQuery() throws Exception {
        this.setupIndex();
        ITask task1 = this.context.createRepositoryTask();
        this.setSummary(task1, "one two three");
        ITask task2 = this.context.createRepositoryTask();
        this.setSummary(task2, "two three four");
        ITask task3 = this.context.createRepositoryTask();
        this.setSummary(task3, "three four five");
        String repositoryUrl = task1.getRepositoryUrl();
        Assert.assertEquals((Object)repositoryUrl, (Object)task2.getRepositoryUrl());
        Assert.assertEquals((Object)repositoryUrl, (Object)task3.getRepositoryUrl());
        repositoryUrl = this.index.escapeFieldValue(repositoryUrl);
        this.index.reindex();
        this.index.waitUntilIdle();
        this.index.setDefaultField(TaskListIndex.FIELD_CONTENT);
        String pattern = "repository_url:%s AND (summary:%s* OR task_key:%s)";
        String query = String.format(pattern, repositoryUrl, "five", task1.getTaskKey());
        Assert.assertTrue((boolean)this.index.matches(task1, query));
        Assert.assertFalse((boolean)this.index.matches(task2, query));
        Assert.assertTrue((boolean)this.index.matches(task3, query));
        query = String.format(pattern, repositoryUrl, task2.getTaskKey(), task2.getTaskKey());
        Assert.assertFalse((boolean)this.index.matches(task1, query));
        Assert.assertTrue((boolean)this.index.matches(task2, query));
        Assert.assertFalse((boolean)this.index.matches(task3, query));
        query = String.format(pattern, repositoryUrl, "two", "something.irrelevant");
        Assert.assertTrue((boolean)this.index.matches(task1, query));
        Assert.assertTrue((boolean)this.index.matches(task2, query));
        Assert.assertFalse((boolean)this.index.matches(task3, query));
    }

    private void setSummary(ITask task, String summary) throws CoreException {
        task.setSummary(summary);
        TaskData taskData = this.context.getDataManager().getTaskData(task);
        taskData.getRoot().getMappedAttribute("task.common.summary").setValue(summary);
        this.context.getDataManager().putSubmittedTaskData(task, taskData, (IDelegatingProgressMonitor)new DelegatingProgressMonitor());
        this.context.getTaskList().notifyElementsChanged(Collections.singleton(task));
    }

    private void assertCanFindTask(ITask task) {
        TestTaskCollector collector = new TestTaskCollector();
        this.index.find(task.getSummary(), (TaskListIndex.TaskCollector)collector, 1000);
        Assert.assertEquals((long)1L, (long)collector.getTasks().size());
        Assert.assertTrue((boolean)collector.getTasks().contains(task));
    }

    private static class TestTaskCollector
    extends TaskListIndex.TaskCollector {
        private final List<ITask> tasks = new ArrayList<ITask>();

        private TestTaskCollector() {
        }

        public void collect(ITask task) {
            this.tasks.add(task);
        }

        public List<ITask> getTasks() {
            return this.tasks;
        }
    }
}

