/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskAttributeMetaDataTest
extends TestCase {
    private TaskData data;

    protected void setUp() throws Exception {
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        this.data = new TaskData(new TaskAttributeMapper(taskRepository), "mock", "http://mockrepository.test", "taskid");
    }

    public void testInitialRequiredAttribute() {
        TaskAttribute attribute = new TaskAttribute(this.data.getRoot(), "attributeId");
        boolean required = attribute.getMetaData().isRequired();
        TaskAttributeMetaDataTest.assertFalse((boolean)required);
    }

    public void testLifecycleRequiredAttribute() {
        TaskAttribute attribute = new TaskAttribute(this.data.getRoot(), "attributeId");
        attribute.getMetaData().setRequired(true);
        TaskAttributeMetaDataTest.assertTrue((boolean)attribute.getMetaData().isRequired());
        attribute.getMetaData().setRequired(false);
        TaskAttributeMetaDataTest.assertFalse((boolean)attribute.getMetaData().isRequired());
    }

    public void testPrecision() throws Exception {
        TaskAttribute attribute = new TaskAttribute(this.data.getRoot(), "attributeId");
        TaskAttributeMetaData metaData = attribute.getMetaData();
        TimeUnit[] timeUnitArray = TimeUnit.values();
        int n = timeUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeUnit unit = timeUnitArray[n2];
            metaData.setPrecision(unit);
            TaskAttributeMetaDataTest.assertEquals((Object)((Object)unit), (Object)((Object)metaData.getPrecision()));
            ++n2;
        }
        metaData.setPrecision(null);
        TaskAttributeMetaDataTest.assertNull((Object)((Object)metaData.getPrecision()));
        metaData.putValue("task.meta.precision", "blah");
        TaskAttributeMetaDataTest.assertNull((Object)((Object)metaData.getPrecision()));
        metaData.putValue("task.meta.precision", TimeUnit.HOURS.name());
        TaskAttributeMetaDataTest.assertEquals((Object)((Object)TimeUnit.HOURS), (Object)((Object)metaData.getPrecision()));
    }
}

