/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataExternalizer;

public class Xml11InputStreamTest
extends TestCase {
    public void testShortStream() throws Exception {
        ByteArrayInputStream source = new ByteArrayInputStream("foo bar".getBytes());
        TaskDataExternalizer.Xml11InputStream in = new TaskDataExternalizer.Xml11InputStream((InputStream)source);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
        try {
            Xml11InputStreamTest.assertEquals((String)"<?xml version=\"1.1\" encoding=\"UTF-8\"?>", (String)reader.readLine());
            Xml11InputStreamTest.fail((String)"Expected EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testXml10Stream() throws Exception {
        ByteArrayInputStream source = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
        TaskDataExternalizer.Xml11InputStream in = new TaskDataExternalizer.Xml11InputStream((InputStream)source);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
        Xml11InputStreamTest.assertEquals((String)"<?xml version=\"1.1\" encoding=\"UTF-8\"?>", (String)reader.readLine());
        Xml11InputStreamTest.assertEquals((int)-1, (int)in.read());
    }

    public void testXml10StreamMultiLines() throws Exception {
        ByteArrayInputStream source = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<abc>\n<def>".getBytes());
        TaskDataExternalizer.Xml11InputStream in = new TaskDataExternalizer.Xml11InputStream((InputStream)source);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        Xml11InputStreamTest.assertEquals((String)"<?xml version=\"1.1\" encoding=\"UTF-8\"?>", (String)reader.readLine());
        Xml11InputStreamTest.assertEquals((String)"<abc>", (String)reader.readLine());
        Xml11InputStreamTest.assertEquals((String)"<def>", (String)reader.readLine());
        Xml11InputStreamTest.assertEquals(null, (String)reader.readLine());
    }

    public void testSkipRead() throws Exception {
        ByteArrayInputStream source = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
        TaskDataExternalizer.Xml11InputStream in = new TaskDataExternalizer.Xml11InputStream((InputStream)source);
        Xml11InputStreamTest.assertEquals((long)0L, (long)in.skip(0L));
        Xml11InputStreamTest.assertEquals((int)60, (int)in.read());
        Xml11InputStreamTest.assertEquals((long)5L, (long)in.skip(5L));
        Xml11InputStreamTest.assertEquals((int)118, (int)in.read());
    }

    public void testSkipReadLine() throws Exception {
        ByteArrayInputStream source = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
        TaskDataExternalizer.Xml11InputStream in = new TaskDataExternalizer.Xml11InputStream((InputStream)source);
        Xml11InputStreamTest.assertEquals((long)3L, (long)in.skip(3L));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        Xml11InputStreamTest.assertEquals((String)"ml version=\"1.1\" encoding=\"UTF-8\"?>", (String)reader.readLine());
        Xml11InputStreamTest.assertEquals(null, (String)reader.readLine());
    }

    public void testSkipHeader() throws Exception {
        ByteArrayInputStream source = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>abc".getBytes());
        TaskDataExternalizer.Xml11InputStream in = new TaskDataExternalizer.Xml11InputStream((InputStream)source);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        Xml11InputStreamTest.assertEquals((long)38L, (long)reader.skip(38L));
        Xml11InputStreamTest.assertEquals((String)"abc", (String)reader.readLine());
        Xml11InputStreamTest.assertEquals(null, (String)reader.readLine());
    }
}

