/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import java.io.BufferedReader;
import java.io.StringReader;
import org.eclipse.mylyn.internal.trac.core.client.WebSearchResultParser;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.junit.Assert;
import org.junit.Test;

public class WebSearchResultParserTest {
    private final WebSearchResultParser parser = new WebSearchResultParser();

    @Test
    public void testParseEmptyValue() throws Exception {
        String input = "id\tsummary\tmilestone\towner\ttype\tstatus\tpriority\n";
        input = String.valueOf(input) + "32\tsearchMilestone2 Ls9JM2\tmilestone1\t\tdefect\tnew\tmajor\n";
        this.parser.parse(new BufferedReader(new StringReader(input)));
        Assert.assertEquals((long)1L, (long)this.parser.getTickets().size());
        TracTicket ticket = (TracTicket)this.parser.getTickets().get(0);
        Assert.assertEquals((long)32L, (long)ticket.getId());
        Assert.assertEquals((Object)"searchMilestone2 Ls9JM2", (Object)ticket.getValue(TracTicket.Key.SUMMARY));
        Assert.assertEquals((Object)"milestone1", (Object)ticket.getValue(TracTicket.Key.MILESTONE));
        Assert.assertEquals((Object)"", (Object)ticket.getValue(TracTicket.Key.OWNER));
        Assert.assertEquals((Object)"new", (Object)ticket.getValue(TracTicket.Key.STATUS));
        Assert.assertEquals((Object)"major", (Object)ticket.getValue(TracTicket.Key.PRIORITY));
    }

    @Test
    public void testParseEmptyValue_Trac0_11() throws Exception {
        String input = "id\towner\ttype\tstatus\tpriority\tcomponent\tversion\n";
        input = String.valueOf(input) + "58\t< default >\tdefect\tnew\tmajor\t--\t--\n";
        this.parser.parse(new BufferedReader(new StringReader(input)));
        Assert.assertEquals((long)1L, (long)this.parser.getTickets().size());
        TracTicket ticket = (TracTicket)this.parser.getTickets().get(0);
        Assert.assertEquals((long)58L, (long)ticket.getId());
        Assert.assertEquals((Object)"< default >", (Object)ticket.getValue(TracTicket.Key.OWNER));
        Assert.assertEquals((Object)"defect", (Object)ticket.getValue(TracTicket.Key.TYPE));
        Assert.assertEquals((Object)"new", (Object)ticket.getValue(TracTicket.Key.STATUS));
        Assert.assertEquals((Object)"major", (Object)ticket.getValue(TracTicket.Key.PRIORITY));
        Assert.assertEquals(null, (Object)ticket.getValue(TracTicket.Key.COMPONENT));
        Assert.assertEquals(null, (Object)ticket.getValue(TracTicket.Key.VERSION));
    }
}

