/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.OrmConcurrencyException;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.OrmRunnable;
import com.google.gwtorm.client.Schema;
import com.google.gwtorm.client.StatementExecutor;
import com.google.gwtorm.client.Transaction;
import com.google.gwtorm.jdbc.Database;
import com.google.gwtorm.jdbc.JdbcTransaction;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public abstract class JdbcSchema
implements Schema {
    private static final int MAX_TRIES = 10;
    private final Database<?> dbDef;
    private Connection conn;

    protected JdbcSchema(Database<?> d, Connection c) {
        this.dbDef = d;
        this.conn = c;
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final SqlDialect getDialect() {
        return this.dbDef.getDialect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, S extends Schema> T run(OrmRunnable<T, S> task) throws OrmException {
        int attempts = 1;
        while (true) {
            try {
                Transaction txn = this.beginTransaction();
                try {
                    T t = task.run(this, txn, attempts > 1);
                    return t;
                }
                finally {
                    txn.commit();
                }
            }
            catch (OrmConcurrencyException err) {
                if (attempts >= 10) throw err;
                ++attempts;
                continue;
            }
            break;
        }
    }

    @Override
    public void updateSchema(StatementExecutor e) throws OrmException {
        try {
            this.createSequences(e);
            this.createRelations(e);
            for (RelationModel rel : this.dbDef.getSchemaModel().getRelations()) {
                this.addColumns(e, rel);
            }
        }
        catch (SQLException err) {
            throw new OrmException("Cannot update schema", err);
        }
    }

    private void createSequences(StatementExecutor e) throws OrmException, SQLException {
        SqlDialect dialect = this.dbDef.getDialect();
        SchemaModel model = this.dbDef.getSchemaModel();
        Set<String> have = dialect.listSequences(this.getConnection());
        for (SequenceModel s : model.getSequences()) {
            if (have.contains(s.getSequenceName().toLowerCase())) continue;
            e.execute(s.getCreateSequenceSql(dialect));
        }
    }

    private void createRelations(StatementExecutor e) throws SQLException, OrmException {
        SqlDialect dialect = this.dbDef.getDialect();
        SchemaModel model = this.dbDef.getSchemaModel();
        Set<String> have = dialect.listTables(this.getConnection());
        for (RelationModel r : model.getRelations()) {
            if (have.contains(r.getRelationName().toLowerCase())) continue;
            e.execute(r.getCreateTableSql(dialect));
        }
    }

    private void addColumns(StatementExecutor e, RelationModel rel) throws SQLException, OrmException {
        SqlDialect dialect = this.dbDef.getDialect();
        SchemaModel model = this.dbDef.getSchemaModel();
        Set<String> have = dialect.listColumns(this.getConnection(), rel.getRelationName().toLowerCase());
        for (ColumnModel c : rel.getColumns()) {
            if (have.contains(c.getColumnName().toLowerCase())) continue;
            dialect.addColumn(e, rel.getRelationName(), c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameField(StatementExecutor e, String table, String from, String to) throws OrmException {
        RelationModel rel = this.findRelationModel(table);
        if (rel == null) {
            throw new OrmException("Relation " + table + " not defined");
        }
        ColumnModel col = rel.getField(to);
        if (col == null) {
            throw new OrmException("Relation " + table + " does not have " + to);
        }
        try {
            Statement s = this.getConnection().createStatement();
            try {
                this.getDialect().renameColumn(e, table, from, col);
            }
            finally {
                s.close();
            }
        }
        catch (SQLException err) {
            throw new OrmException("Cannot rename " + table + "." + from + " to " + to, err);
        }
    }

    private RelationModel findRelationModel(String table) {
        for (RelationModel rel : this.dbDef.getSchemaModel().getRelations()) {
            if (!table.equalsIgnoreCase(rel.getRelationName())) continue;
            return rel;
        }
        return null;
    }

    @Override
    public void pruneSchema(StatementExecutor e) throws OrmException {
        try {
            this.pruneSequences(e);
            this.pruneRelations(e);
            for (RelationModel rel : this.dbDef.getSchemaModel().getRelations()) {
                this.pruneColumns(e, rel);
            }
        }
        catch (SQLException err) {
            throw new OrmException("Schema prune failure", err);
        }
    }

    private void pruneSequences(StatementExecutor e) throws SQLException, OrmException {
        SqlDialect dialect = this.dbDef.getDialect();
        SchemaModel model = this.dbDef.getSchemaModel();
        HashSet<String> want = new HashSet<String>();
        for (SequenceModel s : model.getSequences()) {
            want.add(s.getSequenceName().toLowerCase());
        }
        for (String sequence : dialect.listSequences(this.getConnection())) {
            if (want.contains(sequence)) continue;
            e.execute(dialect.getDropSequenceSql(sequence));
        }
    }

    private void pruneRelations(StatementExecutor e) throws SQLException, OrmException {
        SqlDialect dialect = this.dbDef.getDialect();
        SchemaModel model = this.dbDef.getSchemaModel();
        HashSet<String> want = new HashSet<String>();
        for (RelationModel r : model.getRelations()) {
            want.add(r.getRelationName().toLowerCase());
        }
        for (String table : dialect.listTables(this.getConnection())) {
            if (want.contains(table)) continue;
            e.execute("DROP TABLE " + table);
        }
    }

    private void pruneColumns(StatementExecutor e, RelationModel rel) throws SQLException, OrmException {
        SqlDialect dialect = this.dbDef.getDialect();
        SchemaModel model = this.dbDef.getSchemaModel();
        HashSet<String> want = new HashSet<String>();
        for (ColumnModel c : rel.getColumns()) {
            want.add(c.getColumnName().toLowerCase());
        }
        for (String column : dialect.listColumns(this.getConnection(), rel.getRelationName().toLowerCase())) {
            if (want.contains(column)) continue;
            dialect.dropColumn(e, rel.getRelationName(), column);
        }
    }

    protected long nextLong(String query) throws OrmException {
        return this.getDialect().nextLong(this.getConnection(), query);
    }

    @Override
    public Transaction beginTransaction() {
        return new JdbcTransaction(this);
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn = null;
        }
    }
}

