/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core.model;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.mylyn.reviews.core.model.IApprovalType;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommit;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IRequirementEntry;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewerEntry;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.model.RequirementStatus;
import org.eclipse.mylyn.reviews.core.model.ReviewStatus;
import org.eclipse.mylyn.reviews.internal.core.model.ApprovalType;
import org.eclipse.mylyn.reviews.internal.core.model.ApprovalValueMap;
import org.eclipse.mylyn.reviews.internal.core.model.Change;
import org.eclipse.mylyn.reviews.internal.core.model.Comment;
import org.eclipse.mylyn.reviews.internal.core.model.Commit;
import org.eclipse.mylyn.reviews.internal.core.model.FileItem;
import org.eclipse.mylyn.reviews.internal.core.model.FileVersion;
import org.eclipse.mylyn.reviews.internal.core.model.LineLocation;
import org.eclipse.mylyn.reviews.internal.core.model.LineRange;
import org.eclipse.mylyn.reviews.internal.core.model.Repository;
import org.eclipse.mylyn.reviews.internal.core.model.RequirementEntry;
import org.eclipse.mylyn.reviews.internal.core.model.Review;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewItemSet;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewRequirementsMap;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewerEntry;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;
import org.eclipse.mylyn.reviews.internal.core.model.User;
import org.eclipse.mylyn.reviews.internal.core.model.UserApprovalsMap;

public class ReviewsFactory
extends EFactoryImpl
implements IReviewsFactory {
    public static final ReviewsFactory eINSTANCE = ReviewsFactory.init();

    public static ReviewsFactory init() {
        try {
            ReviewsFactory theReviewsFactory = (ReviewsFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/mylyn/reviews/core/1.0");
            if (theReviewsFactory != null) {
                return theReviewsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ReviewsFactory();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createChange();
            }
            case 2: {
                return this.createReview();
            }
            case 3: {
                return this.createComment();
            }
            case 6: {
                return this.createUser();
            }
            case 7: {
                return this.createRepository();
            }
            case 8: {
                return this.createFileItem();
            }
            case 9: {
                return this.createReviewItemSet();
            }
            case 10: {
                return this.createLineLocation();
            }
            case 11: {
                return this.createLineRange();
            }
            case 12: {
                return this.createFileVersion();
            }
            case 15: {
                return this.createApprovalType();
            }
            case 16: {
                return (EObject)this.createUserApprovalsMap();
            }
            case 17: {
                return this.createReviewerEntry();
            }
            case 18: {
                return (EObject)this.createApprovalValueMap();
            }
            case 19: {
                return this.createRequirementEntry();
            }
            case 20: {
                return (EObject)this.createReviewRequirementsMap();
            }
            case 21: {
                return this.createCommit();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 22: {
                return this.createRequirementStatusFromString(eDataType, initialValue);
            }
            case 23: {
                return this.createReviewStatusFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 22: {
                return this.convertRequirementStatusToString(eDataType, instanceValue);
            }
            case 23: {
                return this.convertReviewStatusToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public IReview createReview() {
        Review review = new Review();
        return review;
    }

    @Override
    public IComment createComment() {
        Comment comment = new Comment();
        return comment;
    }

    @Override
    public IUser createUser() {
        User user = new User();
        return user;
    }

    @Override
    public IRepository createRepository() {
        Repository repository = new Repository();
        return repository;
    }

    @Override
    public IFileItem createFileItem() {
        FileItem fileItem = new FileItem();
        return fileItem;
    }

    @Override
    public IReviewItemSet createReviewItemSet() {
        ReviewItemSet reviewItemSet = new ReviewItemSet();
        return reviewItemSet;
    }

    @Override
    public ILineLocation createLineLocation() {
        LineLocation lineLocation = new LineLocation();
        return lineLocation;
    }

    @Override
    public ILineRange createLineRange() {
        LineRange lineRange = new LineRange();
        return lineRange;
    }

    @Override
    public IFileVersion createFileVersion() {
        FileVersion fileVersion = new FileVersion();
        return fileVersion;
    }

    @Override
    public IReviewerEntry createReviewerEntry() {
        ReviewerEntry reviewerEntry = new ReviewerEntry();
        return reviewerEntry;
    }

    @Override
    public IApprovalType createApprovalType() {
        ApprovalType approvalType = new ApprovalType();
        return approvalType;
    }

    public Map.Entry<IApprovalType, Integer> createApprovalValueMap() {
        ApprovalValueMap approvalValueMap = new ApprovalValueMap();
        return approvalValueMap;
    }

    @Override
    public IRequirementEntry createRequirementEntry() {
        RequirementEntry requirementEntry = new RequirementEntry();
        return requirementEntry;
    }

    public Map.Entry<IApprovalType, IRequirementEntry> createReviewRequirementsMap() {
        ReviewRequirementsMap reviewRequirementsMap = new ReviewRequirementsMap();
        return reviewRequirementsMap;
    }

    @Override
    public ICommit createCommit() {
        Commit commit = new Commit();
        return commit;
    }

    public RequirementStatus createRequirementStatusFromString(EDataType eDataType, String initialValue) {
        RequirementStatus result = RequirementStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRequirementStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ReviewStatus createReviewStatusFromString(EDataType eDataType, String initialValue) {
        ReviewStatus result = ReviewStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertReviewStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Map.Entry<IUser, IReviewerEntry> createUserApprovalsMap() {
        UserApprovalsMap userApprovalsMap = new UserApprovalsMap();
        return userApprovalsMap;
    }

    @Override
    public IChange createChange() {
        Change change = new Change();
        return change;
    }

    public ReviewsPackage getReviewsPackage() {
        return (ReviewsPackage)this.getEPackage();
    }

    @Deprecated
    public static ReviewsPackage getPackage() {
        return ReviewsPackage.eINSTANCE;
    }
}

