/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ccvs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.mapping.CVSCheckedInChangeSet;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;

public class CvsLinkedTaskInfoAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_TYPES = new Class[]{AbstractTaskReference.class};

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }

    public Object getAdapter(Object object, Class adapterType) {
        if (!AbstractTaskReference.class.equals((Object)adapterType)) {
            return null;
        }
        return this.adaptFromComment(object);
    }

    private AbstractTaskReference adaptFromComment(Object object) {
        TaskRepository repository;
        IResource resource;
        String comment = CvsLinkedTaskInfoAdapterFactory.getCommentForElement(object);
        if (comment == null) {
            return null;
        }
        long timestamp = 0L;
        if (object instanceof CVSFileRevision) {
            timestamp = ((CVSFileRevision)object).getTimestamp();
        }
        if ((resource = CvsLinkedTaskInfoAdapterFactory.getResourceForElement(object)) != null && (repository = TasksUiPlugin.getDefault().getRepositoryForResource(resource)) != null) {
            return new LinkedTaskInfo(repository.getRepositoryUrl(), null, null, comment, timestamp);
        }
        return new LinkedTaskInfo(null, null, null, comment);
    }

    private static String getCommentForElement(Object element) {
        if (element instanceof IContextChangeSet) {
            return ((IContextChangeSet)element).getComment(false);
        }
        if (element instanceof DiffChangeSet) {
            return ((DiffChangeSet)element).getComment();
        }
        if (element instanceof LogEntry) {
            return ((LogEntry)element).getComment();
        }
        if (element instanceof IFileRevision) {
            return ((IFileRevision)element).getComment();
        }
        if (element instanceof CVSCheckedInChangeSet) {
            return ((CVSCheckedInChangeSet)element).getComment();
        }
        return null;
    }

    private static IResource getResourceForElement(Object element) {
        RemoteResource remoteResource;
        String path;
        IAdaptable adaptable;
        IResourceVariant resourceVariant;
        if (element instanceof IAdaptable && (resourceVariant = (IResourceVariant)(adaptable = (IAdaptable)element).getAdapter(IResourceVariant.class)) != null && resourceVariant instanceof RemoteResource && (path = (remoteResource = (RemoteResource)resourceVariant).getRepositoryRelativePath()) != null) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible()) {
                    ICVSFolder cvsResource = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
                    try {
                        String repositoryRelativePath = cvsResource.getRepositoryRelativePath();
                        if (repositoryRelativePath != null && path.startsWith(repositoryRelativePath)) {
                            return project;
                        }
                    }
                    catch (CVSException cVSException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

