/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.dialog.DialogPageSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.RepositoryValidator;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.CertificateCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.repositories.ui.IPartContainer;
import org.eclipse.mylyn.commons.repositories.ui.Messages;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.commons.repositories.ui.RepositoryLocationValueProperty;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.statushandlers.StatusManager;

public class RepositoryLocationPart {
    protected static final String PREFS_PAGE_ID_NET_PROXY = "org.eclipse.ui.net.NetPreferences";
    private DataBindingContext bindingContext;
    private boolean needsAdditionalSections;
    private boolean needsAnonymousLogin;
    private boolean needsCertificateAuth;
    private boolean needsHttpAuth;
    private boolean needsProxy;
    private boolean needsValidation;
    private IAdaptable serviceLocator;
    private final RepositoryLocation workingCopy;

    public RepositoryLocationPart(RepositoryLocation workingCopy) {
        this.workingCopy = workingCopy;
        this.setNeedsProxy(false);
        this.setNeedsHttpAuth(false);
        this.setNeedsCertificateAuth(false);
        this.setNeedsValidation(true);
    }

    public boolean canValidate() {
        return this.getValidator() != null;
    }

    public Control createContents(Composite parent) {
        this.bindingContext = new DataBindingContext();
        WizardPage wizardPage = this.getContainer(WizardPage.class);
        if (wizardPage != null) {
            WizardPageSupport.create((WizardPage)wizardPage, (DataBindingContext)this.bindingContext);
        } else {
            DialogPage page = this.getContainer(DialogPage.class);
            if (page != null) {
                DialogPageSupport.create((DialogPage)page, (DataBindingContext)this.bindingContext);
            }
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        this.createServerSection(composite);
        this.createUserSection(composite);
        Control control = this.createAdditionalContents(composite);
        if (control != null) {
            int minHeight = control.computeSize((int)-1, (int)-1).y;
            GridDataFactory.fillDefaults().grab(true, true).minSize(-1, minHeight).span(3, 1).applyTo(control);
        }
        if (this.needsHttpAuth() || this.needsCertificateAuth() || this.needsProxy() || this.needsAdditionalSections()) {
            final ResizingSectionComposite sectionComposite = new ResizingSectionComposite(composite, 0);
            composite.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    sectionComposite.updateLayout();
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)sectionComposite);
            if (this.needsHttpAuth()) {
                this.createHttpAuthSection(sectionComposite);
            }
            if (this.needsCertificateAuth()) {
                this.createCertificateAuthSection(sectionComposite);
            }
            if (this.needsProxy()) {
                this.createProxySection(sectionComposite);
            }
            this.createSections(sectionComposite);
        }
        return composite;
    }

    public <T> T getContainer(Class<T> clazz) {
        return (T)this.getServiceLocator().getAdapter(clazz);
    }

    public IPartContainer getPartContainer() {
        return this.getContainer(IPartContainer.class);
    }

    public boolean isValidUrl(String url) {
        if (url.startsWith("https://") || url.startsWith("http://")) {
            try {
                new URI(url);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean needsAdditionalSections() {
        return this.needsAdditionalSections;
    }

    public boolean needsAnonymousLogin() {
        return this.needsAnonymousLogin;
    }

    public boolean needsCertificateAuth() {
        return this.needsCertificateAuth;
    }

    public boolean needsHttpAuth() {
        return this.needsHttpAuth;
    }

    public boolean needsProxy() {
        return this.needsProxy;
    }

    public boolean needsValidation() {
        return this.needsValidation;
    }

    public void setNeedsAdditionalSections(boolean needsAdditionalSections) {
        this.needsAdditionalSections = needsAdditionalSections;
    }

    public void setNeedsAnonymousLogin(boolean needsAnonymousLogin) {
        this.needsAnonymousLogin = needsAnonymousLogin;
    }

    public void setNeedsCertificateAuth(boolean needsCertificateAuth) {
        this.needsCertificateAuth = needsCertificateAuth;
    }

    public void setNeedsHttpAuth(boolean needsHttpAuth) {
        this.needsHttpAuth = needsHttpAuth;
    }

    public void setNeedsProxy(boolean needsProxy) {
        this.needsProxy = needsProxy;
    }

    public void setNeedsValidation(boolean needsValidation) {
        this.needsValidation = needsValidation;
    }

    public void setServiceLocator(IAdaptable container) {
        this.serviceLocator = container;
    }

    public void validate() {
        final RepositoryValidator validator = this.getValidator();
        if (validator == null) {
            return;
        }
        final AtomicReference result = new AtomicReference();
        try {
            this.getContainer(IPartContainer.class).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.RepositoryLocationPart_Validating_repository, -1);
                    try {
                        try {
                            result.set(validator.run(monitor));
                        }
                        catch (OperationCanceledException e) {
                            result.set(Status.CANCEL_STATUS);
                            throw new InterruptedException();
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.ui", Messages.RepositoryLocationPart_Unexpected_error_during_repository_validation, (Throwable)e), 7);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        if (result.get() == null) {
            validator.setResult(Status.OK_STATUS);
        } else {
            validator.setResult((IStatus)result.get());
        }
        this.getPartContainer().updateButtons();
        this.applyValidatorResult(validator);
    }

    private CertificateCredentialsListener bindCertificateCredentials(AuthenticationType<CertificateCredentials> authType, Button enabledButton, Text userText, Text passwordText, Button savePasswordButton) {
        CertificateCredentialsListener listener = new CertificateCredentialsListener(authType, enabledButton, userText, passwordText, savePasswordButton);
        listener.restore();
        return listener;
    }

    private UserCredentialsListener bindUserCredentials(AuthenticationType<UserCredentials> authType, Button enabledButton, Text userText, Text passwordText, Text domainText, Button savePasswordButton, boolean reverseEnablement) {
        UserCredentialsListener listener = new UserCredentialsListener(authType, enabledButton, userText, passwordText, domainText, savePasswordButton);
        listener.setEnablementReversed(reverseEnablement);
        listener.restore();
        return listener;
    }

    private void createCertificateAuthSection(SectionComposite parent) {
        int style = 0;
        if (this.getWorkingCopy().getCredentials(AuthenticationType.CERTIFICATE, false) != null) {
            style |= 0x40;
        }
        ExpandableComposite section = parent.createSection(Messages.RepositoryLocationPart_Certificate_Authentiation, style);
        section.clientVerticalSpacing = 5;
        final Composite composite = new Composite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Button enableButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)enableButton);
        enableButton.setText(Messages.RepositoryLocationPart_Enable_certificate_authentication);
        Label label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Keystorefile);
        final Text keyStoreFileNameText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)keyStoreFileNameText);
        Button certBrowseButton = new Button(composite, 8);
        certBrowseButton.setText(Messages.RepositoryLocationPart_Browse);
        certBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(composite.getShell(), 4096);
                fileDialog.setFilterPath(keyStoreFileNameText.getText());
                String fileName = fileDialog.open();
                if (fileName != null) {
                    keyStoreFileNameText.setText(fileName);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        this.bindCertificateCredentials((AuthenticationType<CertificateCredentials>)AuthenticationType.CERTIFICATE, enableButton, keyStoreFileNameText, passwordText, savePasswordButton);
    }

    private void createHttpAuthSection(SectionComposite parent) {
        int style = 0;
        if (this.getWorkingCopy().getCredentials(AuthenticationType.HTTP, false) != null) {
            style |= 0x40;
        }
        ExpandableComposite section = parent.createSection(Messages.RepositoryLocationPart_HTTP_Authentication, style);
        section.clientVerticalSpacing = 5;
        Composite composite = new Composite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Button enableButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)enableButton);
        enableButton.setText(Messages.RepositoryLocationPart_Enable_HTTP_Authentication);
        Label label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_User);
        Text userText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)userText);
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        this.bindUserCredentials((AuthenticationType<UserCredentials>)AuthenticationType.HTTP, enableButton, userText, passwordText, null, savePasswordButton, false);
    }

    private void createProxySection(final SectionComposite parent) {
        int style = 0;
        if (!Boolean.parseBoolean(this.getWorkingCopy().getProperty("org.eclipse.mylyn.repositories.proxy.usedefault"))) {
            style |= 0x40;
        }
        ExpandableComposite section = parent.createSection(Messages.RepositoryLocationPart_Proxy_Server_Configuration, style);
        Composite composite = new Composite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        final Button systemProxyButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)systemProxyButton);
        systemProxyButton.setText(Messages.RepositoryLocationPart_Use_global_Network_Connections_preferences);
        this.bind(systemProxyButton, "org.eclipse.mylyn.repositories.proxy.usedefault");
        Link changeProxySettingsLink = new Link(composite, 0);
        changeProxySettingsLink.setText(Messages.RepositoryLocationPart_Change_Settings);
        changeProxySettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)RepositoryLocationPart.PREFS_PAGE_ID_NET_PROXY, (String[])new String[]{RepositoryLocationPart.PREFS_PAGE_ID_NET_PROXY}, null);
                dlg.open();
            }
        });
        Label label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Proxy_Host);
        final Text proxyHostText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)proxyHostText);
        this.bind(proxyHostText, "org.eclipse.mylyn.repositories.proxy.host");
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Proxy_Port);
        final Text proxyPortText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)proxyPortText);
        this.bind(proxyPortText, "org.eclipse.mylyn.repositories.proxy.port");
        Button enableButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)enableButton);
        enableButton.setText(Messages.RepositoryLocationPart_Enable_Proxy_Authentication);
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_User);
        Text userText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)userText);
        label = new Label(composite, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        final UserCredentialsListener listener = this.bindUserCredentials((AuthenticationType<UserCredentials>)AuthenticationType.PROXY, enableButton, userText, passwordText, null, savePasswordButton, false);
        systemProxyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryLocationPart.this.updateProxyEnablement(listener, proxyPortText, proxyHostText, !systemProxyButton.getSelection());
            }
        });
        this.updateProxyEnablement(listener, proxyPortText, proxyHostText, !systemProxyButton.getSelection());
    }

    private void createServerSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_Server);
        Text urlText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)urlText);
        this.bind(urlText, "url", this.getUrlUpdateValueStrategy(), null);
        label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_Label);
        Text labelText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)labelText);
        this.bind(labelText, "label");
        Button disconnectedButton = new Button(parent, 32);
        disconnectedButton.setText(Messages.RepositoryLocationPart_Disconnected);
        this.bind(disconnectedButton, "org.eclipse.mylyn.tasklist.repositories.offline");
    }

    private void createUserSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_User);
        Text userText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)userText);
        this.bind(userText, "org.eclipse.mylyn.repositories.username");
        Button anonymousButton = new Button(parent, 32);
        anonymousButton.setText(Messages.RepositoryLocationPart_Anonymous);
        label = new Label(parent, 0);
        label.setText(Messages.RepositoryLocationPart_Password);
        Text passwordText = new Text(parent, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)passwordText);
        Button savePasswordButton = new Button(parent, 32);
        savePasswordButton.setText(Messages.RepositoryLocationPart_Save_Password);
        this.bindUserCredentials((AuthenticationType<UserCredentials>)AuthenticationType.REPOSITORY, anonymousButton, userText, passwordText, null, savePasswordButton, true);
    }

    private IAdaptable getServiceLocator() {
        return this.serviceLocator;
    }

    protected void applyValidatorResult(RepositoryValidator validator) {
        IStatus status = validator.getResult();
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                if (status == Status.OK_STATUS) {
                    message = Messages.RepositoryLocationPart_Repository_is_valid;
                }
                this.getPartContainer().setMessage(message, 1);
                break;
            }
            case 1: {
                this.getPartContainer().setMessage(message, 1);
                break;
            }
            case 2: {
                this.getPartContainer().setMessage(message, 2);
                break;
            }
            default: {
                this.getPartContainer().setMessage(message, 3);
            }
        }
    }

    protected void bind(Button button, String property) {
        ISWTObservableValue uiElement = SWTObservables.observeSelection((Control)button);
        IObservableValue modelElement = new RepositoryLocationValueProperty(property, Boolean.FALSE.toString()).observe(this.workingCopy);
        this.bindingContext.bindValue((IObservableValue)uiElement, modelElement, null, null);
    }

    protected void bind(Text text, String property) {
        this.bind(text, property, null, null);
    }

    protected void bind(Text text, String property, UpdateValueStrategy targetObservableValue, UpdateValueStrategy modelObservableValue) {
        ISWTObservableValue uiElement = SWTObservables.observeText((Control)text, (int)24);
        IObservableValue modelElement = new RepositoryLocationValueProperty(property, null).observe(this.workingCopy);
        this.bindingContext.bindValue((IObservableValue)uiElement, modelElement, targetObservableValue, modelObservableValue);
    }

    protected Control createAdditionalContents(Composite composite) {
        return null;
    }

    protected void createSections(SectionComposite sectionComposite) {
    }

    protected UpdateValueStrategy getUrlUpdateValueStrategy() {
        return new UpdateValueStrategy().setAfterConvertValidator((IValidator)new UrlValidator());
    }

    protected RepositoryValidator getValidator() {
        return null;
    }

    protected RepositoryLocation getWorkingCopy() {
        return this.workingCopy;
    }

    protected void updateProxyEnablement(UserCredentialsListener listener, Text hostText, Text portText, boolean selected) {
        hostText.setEnabled(selected);
        portText.setEnabled(selected);
        listener.setEnabled(selected);
    }

    private class CertificateCredentialsListener
    implements ModifyListener,
    SelectionListener {
        private final AuthenticationType<CertificateCredentials> authenticationType;
        private final Button enabledButton;
        private final Text keyStoreFileNameText;
        private final Text passwordText;
        private final Button savePasswordButton;
        private boolean updating;

        public CertificateCredentialsListener(AuthenticationType<CertificateCredentials> authenticationType, Button enabledButton, Text keyStoreFileNameText, Text passwordText, Button savePasswordButton) {
            Assert.isNotNull(authenticationType);
            Assert.isNotNull((Object)enabledButton);
            Assert.isNotNull((Object)keyStoreFileNameText);
            Assert.isNotNull((Object)passwordText);
            this.authenticationType = authenticationType;
            this.enabledButton = enabledButton;
            this.keyStoreFileNameText = keyStoreFileNameText;
            this.passwordText = passwordText;
            this.savePasswordButton = savePasswordButton;
            this.init();
        }

        public void modifyText(ModifyEvent event) {
            this.apply();
        }

        public void setEnabled(boolean enabled) {
            if (!enabled) {
                this.enabledButton.setEnabled(false);
                this.setInputFieldsEnabled(false);
            } else {
                this.enabledButton.setEnabled(true);
                this.updateWidgetEnablement();
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.apply();
        }

        public void widgetSelected(SelectionEvent event) {
            this.apply();
            if (event.widget == this.enabledButton) {
                this.updateWidgetEnablement();
            }
        }

        private void apply() {
            if (this.updating) {
                return;
            }
            if (this.getEnabledButtonSelection()) {
                CertificateCredentials credentials = new CertificateCredentials(this.keyStoreFileNameText.getText(), this.passwordText.getText(), null, this.savePasswordButton.getSelection());
                RepositoryLocationPart.this.getWorkingCopy().setCredentials(this.authenticationType, (AuthenticationCredentials)credentials);
            } else {
                RepositoryLocationPart.this.getWorkingCopy().setCredentials(this.authenticationType, null);
            }
        }

        private void restore() {
            try {
                this.updating = true;
                CertificateCredentials credentials = (CertificateCredentials)RepositoryLocationPart.this.getWorkingCopy().getCredentials(this.authenticationType);
                if (credentials != null) {
                    this.enabledButton.setSelection(true);
                    this.keyStoreFileNameText.setText(credentials.getKeyStoreFileName());
                    this.passwordText.setText(credentials.getPassword());
                    this.savePasswordButton.setSelection(credentials.getSavePassword());
                } else {
                    this.enabledButton.setSelection(false);
                    this.keyStoreFileNameText.setText("");
                    this.passwordText.setText("");
                    this.savePasswordButton.setSelection(true);
                }
            }
            finally {
                this.updating = false;
            }
            this.updateWidgetEnablement();
        }

        private void setInputFieldsEnabled(boolean enabled) {
            this.keyStoreFileNameText.setEnabled(enabled);
            this.passwordText.setEnabled(enabled);
            this.savePasswordButton.setEnabled(enabled);
        }

        private void updateWidgetEnablement() {
            this.setInputFieldsEnabled(this.getEnabledButtonSelection());
        }

        protected boolean getEnabledButtonSelection() {
            return this.enabledButton.getSelection();
        }

        protected void init() {
            this.enabledButton.addSelectionListener((SelectionListener)this);
            this.keyStoreFileNameText.addModifyListener((ModifyListener)this);
            this.passwordText.addModifyListener((ModifyListener)this);
            this.savePasswordButton.addSelectionListener((SelectionListener)this);
        }
    }

    private class ResizingSectionComposite
    extends SectionComposite {
        private boolean ignoreUpdate;

        public ResizingSectionComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void reflow(boolean flushCache) {
            super.reflow(flushCache);
            this.updateLayout();
        }

        public void updateLayout() {
            if (this.ignoreUpdate) {
                return;
            }
            try {
                boolean grab;
                this.ignoreUpdate = true;
                ((GridData)this.getLayoutData()).grabExcessVerticalSpace = true;
                boolean bl = grab = this.getSize().y <= this.computeSize((int)-1, (int)-1, (boolean)false).y;
                if (grab != ((GridData)this.getLayoutData()).grabExcessVerticalSpace) {
                    ((GridData)this.getLayoutData()).grabExcessVerticalSpace = grab;
                    this.getParent().layout(true, true);
                }
            }
            finally {
                this.ignoreUpdate = false;
            }
        }
    }

    public class UrlValidator
    implements IValidator {
        public IStatus validate(Object value) {
            if (!RepositoryLocationPart.this.isValidUrl(value.toString())) {
                return new Status(4, "org.eclipse.mylyn.commons.repositories.ui", Messages.RepositoryLocationPart_Enter_a_valid_server_url);
            }
            return Status.OK_STATUS;
        }
    }

    private class UserCredentialsListener
    implements ModifyListener,
    SelectionListener {
        private final AuthenticationType<UserCredentials> authenticationType;
        private final Text domainText;
        private final Button enabledButton;
        private boolean enablementReversed;
        private final Text passwordText;
        private final Button savePasswordButton;
        private boolean updating;
        private final Text userText;

        public UserCredentialsListener(AuthenticationType<UserCredentials> authenticationType, Button enabledButton, Text userText, Text passwordText, Text domainText, Button savePasswordButton) {
            Assert.isNotNull(authenticationType);
            Assert.isNotNull((Object)enabledButton);
            Assert.isNotNull((Object)userText);
            Assert.isNotNull((Object)passwordText);
            this.authenticationType = authenticationType;
            this.enabledButton = enabledButton;
            this.userText = userText;
            this.passwordText = passwordText;
            this.domainText = domainText;
            this.savePasswordButton = savePasswordButton;
            this.init();
        }

        public boolean isEnablementReversed() {
            return this.enablementReversed;
        }

        public void modifyText(ModifyEvent event) {
            this.apply();
        }

        public void setEnabled(boolean enabled) {
            if (!enabled) {
                this.enabledButton.setEnabled(false);
                this.setInputFieldsEnabled(false);
            } else {
                this.enabledButton.setEnabled(true);
                this.updateWidgetEnablement();
            }
        }

        public void setEnablementReversed(boolean enablementReversed) {
            this.enablementReversed = enablementReversed;
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.apply();
        }

        public void widgetSelected(SelectionEvent event) {
            this.apply();
            if (event.widget == this.enabledButton) {
                this.updateWidgetEnablement();
            }
        }

        private void apply() {
            if (this.updating) {
                return;
            }
            if (this.getEnabledButtonSelection()) {
                String domain = this.domainText != null ? this.domainText.getText() : null;
                UserCredentials credentials = new UserCredentials(this.userText.getText(), this.passwordText.getText(), domain, this.savePasswordButton.getSelection());
                RepositoryLocationPart.this.getWorkingCopy().setCredentials(this.authenticationType, (AuthenticationCredentials)credentials);
            } else {
                RepositoryLocationPart.this.getWorkingCopy().setCredentials(this.authenticationType, null);
            }
        }

        private void restore() {
            try {
                this.updating = true;
                UserCredentials credentials = (UserCredentials)RepositoryLocationPart.this.getWorkingCopy().getCredentials(this.authenticationType);
                if (credentials != null) {
                    this.enabledButton.setSelection(!this.isEnablementReversed());
                    this.userText.setText(credentials.getUserName());
                    this.passwordText.setText(credentials.getPassword());
                    if (this.domainText != null) {
                        this.domainText.setText(credentials.getDomain() != null ? credentials.getDomain() : "");
                    }
                    this.savePasswordButton.setSelection(credentials.getSavePassword());
                } else {
                    this.enabledButton.setSelection(this.isEnablementReversed());
                    this.userText.setText("");
                    this.passwordText.setText("");
                    if (this.domainText != null) {
                        this.domainText.setText("");
                    }
                    this.savePasswordButton.setSelection(true);
                }
            }
            finally {
                this.updating = false;
            }
            this.updateWidgetEnablement();
        }

        private void setInputFieldsEnabled(boolean enabled) {
            this.userText.setEnabled(enabled);
            this.passwordText.setEnabled(enabled);
            if (this.domainText != null) {
                this.domainText.setEnabled(enabled);
            }
            this.savePasswordButton.setEnabled(enabled);
        }

        private void updateWidgetEnablement() {
            this.setInputFieldsEnabled(this.getEnabledButtonSelection());
        }

        protected boolean getEnabledButtonSelection() {
            return this.enabledButton.getSelection() ^ this.isEnablementReversed();
        }

        protected void init() {
            this.enabledButton.addSelectionListener((SelectionListener)this);
            this.userText.addModifyListener((ModifyListener)this);
            this.passwordText.addModifyListener((ModifyListener)this);
            if (this.domainText != null) {
                this.domainText.addModifyListener((ModifyListener)this);
            }
            this.savePasswordButton.addSelectionListener((SelectionListener)this);
        }
    }
}

