/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ant;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.text.AntAnnotationModel;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.ant.internal.ui.model.IProblemRequestor;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.ide.ant.AntEditingMonitor;
import org.eclipse.mylyn.internal.ide.ui.XmlNodeHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

public class AntStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "build.xml";
    private static final char HANDLE_PATH_SEPARATOR = ';';

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String elementHandle) {
        if (elementHandle.endsWith(".xml")) {
            return this.parentContentType;
        }
        return CONTENT_TYPE;
    }

    public List<String> getChildHandles(String handle) {
        return Collections.emptyList();
    }

    public String getParentHandle(String handle) {
        Object o = this.getObjectForHandle(handle);
        if (o instanceof AntElementNode) {
            IAntElement parent = ((AntElementNode)o).getParentNode();
            if (parent != null) {
                return this.getHandleIdentifier(parent);
            }
            int delimeterIndex = handle.indexOf(";");
            if (delimeterIndex != -1) {
                String parentHandle = handle.substring(0, delimeterIndex);
                return parentHandle;
            }
            return null;
        }
        if (o instanceof IFile) {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            return parentBridge.getParentHandle(handle);
        }
        return null;
    }

    public Object getObjectForHandle(String handle) {
        block8: {
            block7: {
                if (handle != null) break block7;
                return null;
            }
            try {
                int first = handle.indexOf(59);
                String filename = "";
                if (first == -1) {
                    filename = handle;
                    Path path = new Path(filename);
                    IFile f = (IFile)((Workspace)ResourcesPlugin.getWorkspace()).newResource((IPath)path, 1);
                    return f;
                }
                filename = handle.substring(0, first);
                Path path = new Path(filename);
                IFile file = (IFile)((Workspace)ResourcesPlugin.getWorkspace()).newResource((IPath)path, 1);
                FileEditorInput fei = new FileEditorInput(file);
                String elementPath = handle.substring(first + 1);
                if (elementPath.equals("")) {
                    return file;
                }
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart instanceof AntEditor) {
                    AntModel antModel = ((AntEditor)editorPart).getAntModel();
                    if (antModel != null) {
                        return AntEditingMonitor.getNode(antModel, elementPath);
                    }
                    break block8;
                }
                String content = XmlNodeHelper.getContents((InputStream)file.getContents());
                Document d = new Document(content);
                AntAnnotationModel p = new AntAnnotationModel(file);
                AntModel am = new AntModel((IDocument)d, (IProblemRequestor)p, new LocationProvider((IEditorInput)fei));
                am.reconcile();
                return AntEditingMonitor.getNode(am, elementPath);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public String getHandleIdentifier(Object object) {
        File file;
        if (object instanceof XmlNodeHelper) {
            return ((XmlNodeHelper)object).getHandle();
        }
        if (object instanceof AntElementNode) {
            AntElementNode node = (AntElementNode)object;
            String path = node.getElementPath();
            if (path == null || node.getIFile() == null) {
                return null;
            }
            XmlNodeHelper helper = new XmlNodeHelper(node.getIFile().getFullPath().toString(), path);
            return helper.getHandle();
        }
        if (object instanceof File && (file = (File)object).getFullPath().toString().endsWith(CONTENT_TYPE)) {
            return file.getFullPath().toString();
        }
        return null;
    }

    public String getLabel(Object object) {
        File file;
        if (object instanceof AntElementNode) {
            AntElementNode n = (AntElementNode)object;
            String name = String.valueOf(n.getIFile().getName()) + ": " + n.getName();
            return name;
        }
        if (object instanceof File && (file = (File)object).getFullPath().toString().endsWith(CONTENT_TYPE)) {
            return CONTENT_TYPE;
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        if (handle != null) {
            return handle.indexOf(59) == -1;
        }
        return false;
    }

    public boolean acceptsObject(Object object) {
        File file;
        if (object instanceof AntElementNode) {
            return true;
        }
        return object instanceof XmlNodeHelper ? ((XmlNodeHelper)object).getFilename().endsWith(CONTENT_TYPE) : object instanceof File && (file = (File)object).getFullPath().toString().endsWith(CONTENT_TYPE);
    }

    public boolean canFilter(Object element) {
        return true;
    }

    public boolean isDocument(String handle) {
        return handle.indexOf(59) == -1;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        block15: {
            IResource markerResource;
            block14: {
                if (object == null) {
                    return null;
                }
                markerResource = null;
                try {
                    if (object instanceof ConcreteMarker) {
                        markerResource = ((ConcreteMarker)object).getMarker().getResource();
                        break block14;
                    }
                    if (object instanceof Marker) {
                        markerResource = ((Marker)object).getResource();
                        break block14;
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (markerResource != null) {
                try {
                    if (markerResource instanceof IFile) {
                        IFile file = (IFile)markerResource;
                        if (file.getFullPath().toString().endsWith(CONTENT_TYPE)) {
                            return file.getFullPath().toString();
                        }
                        return null;
                    }
                    return null;
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.ide.ant", "Could not find element for: " + object, t));
                    return null;
                }
            }
            if (object instanceof IFile) {
                String path;
                IFile file;
                block16: {
                    file = (IFile)object;
                    if (!file.getFullPath().toString().endsWith(CONTENT_TYPE)) break block15;
                    FileEditorInput fei = new FileEditorInput(file);
                    String content = XmlNodeHelper.getContents((InputStream)file.getContents());
                    Document d = new Document(content);
                    AntAnnotationModel p = new AntAnnotationModel(file);
                    AntModel am = new AntModel((IDocument)d, (IProblemRequestor)p, new LocationProvider((IEditorInput)fei));
                    am.reconcile();
                    AntElementNode node = am.getNode(offset, false);
                    path = node.getElementPath();
                    if (path != null) break block16;
                    return null;
                }
                try {
                    String handle = new XmlNodeHelper(file.getFullPath().toString(), path).getHandle();
                    return handle;
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.ide.ant", "Unable to get handle for offset in object", (Throwable)e));
                }
            }
        }
        return null;
    }
}

