/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.AtomicUpdate;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.OrmConcurrencyException;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.OrmRunnable;
import com.google.gwtorm.client.Transaction;
import com.google.gwtorm.client.impl.AbstractAccess;
import com.google.gwtorm.client.impl.ListResultSet;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.jdbc.JdbcTransaction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class JdbcAccess<T, K extends Key<?>>
extends AbstractAccess<T, K, JdbcTransaction> {
    private final JdbcSchema schema;

    protected JdbcAccess(JdbcSchema s) {
        this.schema = s;
    }

    @Override
    public final com.google.gwtorm.client.ResultSet<T> get(Iterable<K> keys) throws OrmException {
        ArrayList<Key> keySet;
        if (keys instanceof Collection) {
            keySet = (ArrayList<Key>)keys;
        } else {
            keySet = new ArrayList<Key>();
            for (Key k : keys) {
                keySet.add(k);
            }
        }
        switch (keySet.size()) {
            case 0: {
                return new ListResultSet(Collections.emptyList());
            }
            case 1: {
                Object entity = this.get((Key)keySet.iterator().next());
                if (entity != null) {
                    return new ListResultSet(Collections.singletonList(entity));
                }
                return new ListResultSet(Collections.emptyList());
            }
        }
        return this.getBySqlIn(keySet);
    }

    protected com.google.gwtorm.client.ResultSet<T> getBySqlIn(Collection<K> keys) throws OrmException {
        return super.get(keys);
    }

    protected PreparedStatement prepareStatement(String sql) throws OrmException {
        try {
            return this.schema.getConnection().prepareStatement(sql);
        }
        catch (SQLException e) {
            throw this.convertError("prepare SQL\n" + sql + "\n", e);
        }
    }

    protected PreparedStatement prepareBySqlIn(String sql, Collection<K> keys) throws OrmException {
        int n = keys.size();
        StringBuilder buf = new StringBuilder(sql.length() + n << 2);
        buf.append(sql);
        buf.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append('?');
        }
        buf.append(')');
        return this.prepareStatement(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected T queryOne(PreparedStatement ps) throws OrmException {
        try {
            try {
                T t;
                ResultSet rs = ps.executeQuery();
                try {
                    T r = null;
                    if (rs.next()) {
                        r = this.newEntityInstance();
                        this.bindOneFetch(rs, r);
                        if (rs.next()) {
                            throw new OrmException("Multiple results");
                        }
                    }
                    t = r;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return t;
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException e) {
            throw this.convertError("fetch", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected ListResultSet<T> queryList(PreparedStatement ps) throws OrmException {
        try {
            try {
                ListResultSet listResultSet;
                ResultSet rs = ps.executeQuery();
                try {
                    ArrayList<T> r = new ArrayList<T>();
                    while (rs.next()) {
                        T o = this.newEntityInstance();
                        this.bindOneFetch(rs, o);
                        r.add(o);
                    }
                    listResultSet = new ListResultSet(r);
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return listResultSet;
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException e) {
            throw this.convertError("fetch", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInsert(Iterable<T> instances, JdbcTransaction txn) throws OrmException {
        try {
            Statement ps = null;
            try {
                int cnt = 0;
                for (T o : instances) {
                    if (ps == null) {
                        ps = this.schema.getConnection().prepareStatement(this.getInsertOneSql());
                    }
                    this.bindOneInsert((PreparedStatement)ps, o);
                    ps.addBatch();
                    ++cnt;
                }
                JdbcAccess.execute((PreparedStatement)ps, cnt);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw this.convertError("insert", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpdate(Iterable<T> instances, JdbcTransaction txn) throws OrmException {
        try {
            Statement ps = null;
            try {
                int cnt = 0;
                for (T o : instances) {
                    if (ps == null) {
                        ps = this.schema.getConnection().prepareStatement(this.getUpdateOneSql());
                    }
                    this.bindOneUpdate((PreparedStatement)ps, o);
                    ps.addBatch();
                    ++cnt;
                }
                JdbcAccess.execute((PreparedStatement)ps, cnt);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw this.convertError("update", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpsert(Iterable<T> instances, JdbcTransaction txn) throws OrmException {
        ArrayList<T> inserts = null;
        try {
            Statement ps = null;
            try {
                int cnt = 0;
                for (T o : instances) {
                    if (ps == null) {
                        ps = this.schema.getConnection().prepareStatement(this.getUpdateOneSql());
                    }
                    this.bindOneUpdate((PreparedStatement)ps, o);
                    ps.addBatch();
                    ++cnt;
                }
                if (0 < cnt) {
                    int[] states = ps.executeBatch();
                    if (states == null) {
                        inserts = new ArrayList<T>(cnt);
                        for (T o : instances) {
                            inserts.add(o);
                        }
                    } else {
                        int i = 0;
                        for (T o : instances) {
                            if (states.length <= i || states[i] != 1) {
                                if (inserts == null) {
                                    inserts = new ArrayList(cnt - i);
                                }
                                inserts.add(o);
                            }
                            ++i;
                        }
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw this.convertError("update", e);
        }
        if (inserts != null) {
            this.doInsert((Iterable<T>)inserts, txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(Iterable<T> instances, JdbcTransaction txn) throws OrmException {
        try {
            Statement ps = null;
            try {
                int cnt = 0;
                for (T o : instances) {
                    if (ps == null) {
                        ps = this.schema.getConnection().prepareStatement(this.getDeleteOneSql());
                    }
                    this.bindOneDelete((PreparedStatement)ps, o);
                    ps.addBatch();
                    ++cnt;
                }
                JdbcAccess.execute((PreparedStatement)ps, cnt);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw this.convertError("delete", e);
        }
    }

    private static void execute(PreparedStatement ps, int cnt) throws SQLException, OrmConcurrencyException {
        if (cnt == 0) {
            return;
        }
        int[] states = ps.executeBatch();
        if (states == null) {
            throw new SQLException("No rows affected; expected " + cnt + " rows");
        }
        for (int i = 0; i < cnt; ++i) {
            if (states.length > i && states[i] == 1) continue;
            throw new OrmConcurrencyException();
        }
    }

    @Override
    public T atomicUpdate(K key, AtomicUpdate<T> update) throws OrmException {
        return this.schema.run(new OrmRunnable<T, JdbcSchema>((Key)key, update){
            final /* synthetic */ Key val$key;
            final /* synthetic */ AtomicUpdate val$update;
            {
                this.val$key = key;
                this.val$update = atomicUpdate;
            }

            @Override
            public T run(JdbcSchema db, Transaction txn, boolean retry) throws OrmException {
                Object obj = JdbcAccess.this.get(this.val$key);
                if (obj == null) {
                    return null;
                }
                Object res = this.val$update.update(obj);
                JdbcAccess.this.update(Collections.singleton(obj), txn);
                return res;
            }
        });
    }

    @Override
    public void deleteKeys(Iterable<K> keys) throws OrmException {
        this.delete(this.get(keys));
    }

    private OrmException convertError(String op, SQLException err) {
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return this.schema.getDialect().convertError(op, this.getRelationName(), err);
    }

    protected abstract T newEntityInstance();

    protected abstract String getRelationName();

    protected abstract String getInsertOneSql();

    protected abstract String getUpdateOneSql();

    protected abstract String getDeleteOneSql();

    protected abstract void bindOneInsert(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void bindOneUpdate(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void bindOneDelete(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void bindOneFetch(ResultSet var1, T var2) throws SQLException;
}

