/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.StringKey;

public final class Project {
    @Column(id=1)
    protected NameKey name;
    @Column(id=2, length=0x7FFFFFFF, notNull=false)
    protected String description;
    @Column(id=3)
    protected boolean useContributorAgreements;
    @Column(id=4)
    protected boolean useSignedOffBy;
    @Column(id=5)
    protected char submitType;
    @Column(id=6, notNull=false, name="parent_name")
    protected NameKey parent;

    protected Project() {
    }

    public Project(NameKey newName) {
        this.name = newName;
        this.useContributorAgreements = true;
        this.setSubmitType(SubmitType.MERGE_IF_NECESSARY);
    }

    public NameKey getNameKey() {
        return this.name;
    }

    public String getName() {
        return this.name.get();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public boolean isUseContributorAgreements() {
        return this.useContributorAgreements;
    }

    public void setUseContributorAgreements(boolean u) {
        this.useContributorAgreements = u;
    }

    public boolean isUseSignedOffBy() {
        return this.useSignedOffBy;
    }

    public void setUseSignedOffBy(boolean sbo) {
        this.useSignedOffBy = sbo;
    }

    public SubmitType getSubmitType() {
        return SubmitType.forCode(this.submitType);
    }

    public void setSubmitType(SubmitType type) {
        this.submitType = type.getCode();
    }

    public void copySettingsFrom(Project update) {
        this.description = update.description;
        this.useContributorAgreements = update.useContributorAgreements;
        this.useSignedOffBy = update.useSignedOffBy;
        this.submitType = update.submitType;
    }

    public NameKey getParent() {
        return this.parent;
    }

    public void setParent(NameKey parentProjectName) {
        this.parent = parentProjectName;
    }

    public static class NameKey
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String name;

        protected NameKey() {
        }

        public NameKey(String n) {
            this.name = n;
        }

        public String get() {
            return this.name;
        }

        protected void set(String newValue) {
            this.name = newValue;
        }

        public static NameKey parse(String str) {
            NameKey r = new NameKey();
            r.fromString(str);
            return r;
        }
    }

    public static enum SubmitType {
        FAST_FORWARD_ONLY('F'),
        MERGE_IF_NECESSARY('M'),
        MERGE_ALWAYS('A'),
        CHERRY_PICK('C');

        private final char code;

        private SubmitType(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static SubmitType forCode(char c) {
            for (SubmitType s : SubmitType.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }
}

