/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.sdk.util.AbstractTestFixture;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.ConditionalIgnoreRule;
import org.eclipse.mylyn.commons.sdk.util.IgnoreRuleRuntimeException;
import org.eclipse.mylyn.commons.sdk.util.IgnoreStatement;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.osgi.util.NLS;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class Junit4TestFixtureRunner
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public Junit4TestFixtureRunner(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        if (CommonTestUtil.fixProxyConfiguration()) {
            CommonTestUtil.dumpSystemInfo(System.err);
        }
        String restrictProperty = null;
        String restrictValue = null;
        Class<?> fixtureClass = null;
        String fixtureType = null;
        Annotation[] annotationArray = this.getTestClass().getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == RunOnlyWhenProperty.class) {
                RunOnlyWhenProperty onlyWhenProperty = (RunOnlyWhenProperty)annotation;
                restrictProperty = onlyWhenProperty.property();
                restrictValue = onlyWhenProperty.value();
            }
            if (annotation.annotationType() == FixtureDefinition.class) {
                FixtureDefinition fixtueDef = (FixtureDefinition)annotation;
                fixtureClass = fixtueDef.fixtureClass();
                fixtureType = fixtueDef.fixtureType();
            }
            ++n2;
        }
        if (fixtureType != null) {
            TestConfiguration defFixture = TestConfiguration.getDefault();
            List parametersList = defFixture.discover(fixtureClass, fixtureType);
            ArrayList<AbstractTestFixture> sortedParametersList = new ArrayList<AbstractTestFixture>(parametersList);
            sortedParametersList.sort(new Comparator<AbstractTestFixture>(){

                @Override
                public int compare(AbstractTestFixture o1, AbstractTestFixture o2) {
                    return o1.getInfo().compareTo(o2.getInfo());
                }
            });
            ArrayList<AbstractTestFixture> fixturesToExecute = new ArrayList<AbstractTestFixture>();
            if (restrictProperty != null) {
                for (AbstractTestFixture abstractFixture : sortedParametersList) {
                    String tempProperty = abstractFixture.getProperty(restrictProperty);
                    if (tempProperty == null || !tempProperty.equals(restrictValue)) continue;
                    fixturesToExecute.add(abstractFixture);
                }
                if (fixturesToExecute.size() > 0) {
                    int i = 0;
                    while (i < fixturesToExecute.size()) {
                        this.runners.add((Runner)new TestClassRunnerForFixture(this.getTestClass().getJavaClass(), fixturesToExecute, i));
                        ++i;
                    }
                }
            } else if (sortedParametersList.size() > 0) {
                int i = 0;
                while (i < sortedParametersList.size()) {
                    this.runners.add((Runner)new TestClassRunnerForFixture(this.getTestClass().getJavaClass(), sortedParametersList, i));
                    ++i;
                }
            }
        } else {
            throw new InitializationError("Missing Annotation FixtureDefinition for Junit4TestFixtureRunner");
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FixtureDefinition {
        public Class<?> fixtureClass();

        public String fixtureType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RunOnlyWhenProperty {
        public String property() default "";

        public String value() default "";
    }

    private class TestClassRunnerForFixture
    extends BlockJUnit4ClassRunner {
        private final int fFixtureSetNumber;
        private final List<AbstractTestFixture> fFixtureList;

        TestClassRunnerForFixture(Class<?> type, List<AbstractTestFixture> fixtureList, int i) throws InitializationError {
            super(type);
            this.fFixtureList = fixtureList;
            this.fFixtureSetNumber = i;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.fFixtureList.get(this.fFixtureSetNumber));
        }

        protected String getName() {
            return String.format("[%s %s]", this.fFixtureSetNumber, this.fFixtureList.get(this.fFixtureSetNumber).getSimpleInfo());
        }

        protected String testName(FrameworkMethod method) {
            if (Boolean.parseBoolean(System.getProperty("org.eclipse.mylyn.tests.all"))) {
                return String.format("%s[%s %s]", method.getName(), this.fFixtureSetNumber, this.fFixtureList.get(this.fFixtureSetNumber).getSimpleInfo());
            }
            return super.testName(method);
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            Description description = this.describeChild(method);
            if (this.isIgnored(method)) {
                notifier.fireTestIgnored(description);
            } else {
                Object test = null;
                try {
                    test = new ReflectiveCallable(){

                        protected Object runReflectiveCall() throws Throwable {
                            return TestClassRunnerForFixture.this.createTest();
                        }
                    }.run();
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.sdk.util", NLS.bind((String)"TestClassRunnerForFixture: Testclass {0} has no public constructor", (Object)this.getTestClass().getName()), e));
                    return;
                }
                boolean skipped = false;
                if (test != null) {
                    List testRules = this.getTestRules(test);
                    for (TestRule testRule : testRules) {
                        Statement statement;
                        if (!(testRule instanceof ConditionalIgnoreRule) || !((statement = testRule.apply(null, description)) instanceof IgnoreStatement)) continue;
                        skipped = true;
                        break;
                    }
                    if (skipped) {
                        notifier.fireTestIgnored(description);
                    } else {
                        this.runTest(this.methodBlock(method), description, notifier);
                    }
                }
            }
        }

        /*
         * Loose catch block
         */
        protected final void runTest(Statement statement, Description description, RunNotifier notifier) {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                try {
                    statement.evaluate();
                }
                catch (AssumptionViolatedException e) {
                    eachNotifier.addFailedAssumption(e);
                    eachNotifier.fireTestFinished();
                }
                catch (IgnoreRuleRuntimeException e) {
                    eachNotifier.fireTestIgnored();
                    eachNotifier.fireTestFinished();
                }
                catch (Throwable e) {
                    eachNotifier.addFailure(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    eachNotifier.fireTestFinished();
                }
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        }
    }
}

