/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.ui.ClipboardCopier;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class CopyDetailsActionTest
extends TestCase {
    public void testGetTextForTask() {
        MockTask task = new MockTask("123");
        task.setSummary("abc");
        task.setTaskKey("123");
        String text = CopyTaskDetailsAction.getTextForTask((Object)((Object)task));
        CopyDetailsActionTest.assertEquals((String)"123: abc", (String)text);
        task.setTaskKey(null);
        CopyDetailsActionTest.assertEquals((String)"abc", (String)CopyTaskDetailsAction.getTextForTask((Object)((Object)task)));
    }

    public void testGetSummaryAndUrl() {
        MockTask task = new MockTask("321");
        task.setSummary("s321");
        task.setTaskKey("321");
        MockRepositoryConnector connector = new MockRepositoryConnector(){

            @Override
            public String getTaskUrl(String repositoryUrl, String taskId) {
                return "http://321.com";
            }
        };
        AbstractRepositoryConnector oldConnector = TasksUi.getRepositoryManager().getRepositoryConnector("mock");
        try {
            ((TaskRepositoryManager)TasksUi.getRepositoryManager()).addRepositoryConnector((AbstractRepositoryConnector)connector);
            CopyDetailsActionTest.assertEquals((String)("321: s321" + ClipboardCopier.LINE_SEPARATOR + "http://321.com"), (String)CopyTaskDetailsAction.getTextForTask((Object)((Object)task), (CopyTaskDetailsAction.Mode)CopyTaskDetailsAction.Mode.ID_SUMMARY_URL));
        }
        finally {
            if (oldConnector != null) {
                ((TaskRepositoryManager)TasksUi.getRepositoryManager()).addRepositoryConnector(oldConnector);
            }
        }
    }

    public void testGetBrowseableUrl() {
        MockTask task = new MockTask("123");
        task.setSummary("Ticket 123");
        MockRepositoryConnector connector = new MockRepositoryConnector(){

            @Override
            public String getTaskUrl(String repositoryUrl, String taskId) {
                return "URI://mock-repo/id/123";
            }

            public URL getBrowserUrl(TaskRepository repository, IRepositoryElement element) {
                try {
                    return new URL("http://mock-repo-evolved.com/tickets/123");
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        };
        AbstractRepositoryConnector oldConnector = TasksUi.getRepositoryManager().getRepositoryConnector("mock");
        try {
            ((TaskRepositoryManager)TasksUi.getRepositoryManager()).addRepositoryConnector((AbstractRepositoryConnector)connector);
            CopyDetailsActionTest.assertEquals((String)("123: Ticket 123" + ClipboardCopier.LINE_SEPARATOR + "http://mock-repo-evolved.com/tickets/123"), (String)CopyTaskDetailsAction.getTextForTask((Object)((Object)task), (CopyTaskDetailsAction.Mode)CopyTaskDetailsAction.Mode.ID_SUMMARY_URL));
            CopyDetailsActionTest.assertEquals((String)"http://mock-repo-evolved.com/tickets/123", (String)CopyTaskDetailsAction.getTextForTask((Object)((Object)task), (CopyTaskDetailsAction.Mode)CopyTaskDetailsAction.Mode.URL));
        }
        finally {
            if (oldConnector != null) {
                ((TaskRepositoryManager)TasksUi.getRepositoryManager()).addRepositoryConnector(oldConnector);
            }
        }
    }
}

