/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.tests.util.MockRepositoryConnectorTestCase;

public class AbstractRepositoryConnectorTest
extends MockRepositoryConnectorTestCase {
    public void testGetTaskUrl() {
        AbstractRepositoryConnectorTest.assertEquals((String)"http://mock-repo.com/tickets/123", (String)this.connectorWithUrl.getTaskUrl(this.repositoryWithUrl.getRepositoryUrl(), this.taskWithUrl.getTaskId()));
        AbstractRepositoryConnectorTest.assertEquals((String)"URI://mock-repo/id/123", (String)this.connectorWithBrowserUrl.getTaskUrl(this.repositoryWithBrowserUrl.getRepositoryUrl(), this.taskWithBrowserUrl.getTaskId()));
    }

    public void testGetBrowserUrl() {
        AbstractRepositoryConnectorTest.assertNull((Object)this.connectorWithUrl.getBrowserUrl(this.repositoryWithUrl, (IRepositoryElement)this.taskWithUrl));
        AbstractRepositoryConnectorTest.assertEquals((String)"http://mock-repo-evolved.com/tickets/123", (String)this.connectorWithBrowserUrl.getBrowserUrl(this.repositoryWithBrowserUrl, (IRepositoryElement)this.taskWithBrowserUrl).toString());
    }

    public void testGetTaskByUrl() {
        MockTask taskWithBrowserUrl2 = this.createMockTaskForRepository(this.repositoryWithBrowserUrl, "234");
        TasksUiPlugin.getTaskList().addTask((ITask)taskWithBrowserUrl2);
        MockTask taskWithUrl2 = this.createMockTaskForRepository(this.repositoryWithUrl, "234");
        TasksUiPlugin.getTaskList().addTask((ITask)taskWithUrl2);
        AbstractRepositoryConnectorTest.assertEquals((Object)((Object)taskWithBrowserUrl2), (Object)TasksUiInternal.getTaskByUrl((String)"http://mock-repo-evolved.com/tickets/234"));
        AbstractRepositoryConnectorTest.assertEquals((Object)((Object)taskWithUrl2), (Object)TasksUiInternal.getTaskByUrl((String)"http://mock-repo.com/tickets/234"));
        AbstractRepositoryConnectorTest.assertEquals((Object)((Object)this.taskWithUrl), (Object)TasksUiInternal.getTaskByUrl((String)"http://mock-repo.com/tickets/123"));
        AbstractRepositoryConnectorTest.assertEquals((Object)((Object)this.taskWithBrowserUrl), (Object)TasksUiInternal.getTaskByUrl((String)"http://mock-repo-evolved.com/tickets/123"));
        AbstractRepositoryConnectorTest.assertEquals((Object)((Object)this.taskWithBrowserUrl), (Object)TasksUiInternal.getTaskByUrl((String)"URI://mock-repo/id/123"));
        AbstractRepositoryConnectorTest.assertNull((Object)TasksUiInternal.getTaskByUrl(null));
        AbstractRepositoryConnectorTest.assertNull((Object)TasksUiInternal.getTaskByUrl((String)""));
    }

    public void testIsOwnedByUser() throws Exception {
        this.assertIsOwnedByUser("joel.user", "joel.user", "joel.user", true);
        this.assertIsOwnedByUser("joel.user", "Joel K. User", "joel.user", true);
        this.assertIsOwnedByUser("joel.user", null, "joel.user", true);
        this.assertIsOwnedByUser("joel.user", "joel.user", "123", true);
        this.assertIsOwnedByUser("joel.user", "joel.user", null, true);
        this.assertIsOwnedByUser("joel.user", "Joel K. User", "123", false);
        this.assertIsOwnedByUser("joel.user", "Joel K. User", null, false);
        this.assertIsOwnedByUser("joel.user", null, "123", false);
        this.assertIsOwnedByUser("joel.user", null, null, false);
        this.assertIsOwnedByUser(null, null, null, false);
        this.assertIsOwnedByUser(null, null, "123", false);
        this.assertIsOwnedByUser(null, "Joel K. User", null, false);
        this.assertIsOwnedByUser(null, "joel.user", "joel.user", false);
    }

    private void assertIsOwnedByUser(String repositoryUserName, String taskOwner, String taskOwnerId, boolean expected) {
        if (repositoryUserName == null) {
            this.assertIsOwnedByUserHelper(null, taskOwner, taskOwnerId, expected);
            this.assertIsOwnedByUserHelper("", taskOwner, taskOwnerId, expected);
        } else if (taskOwner == null) {
            this.assertIsOwnedByUserHelper(repositoryUserName, null, taskOwnerId, expected);
            this.assertIsOwnedByUserHelper(repositoryUserName, "", taskOwnerId, expected);
        } else if (taskOwnerId == null) {
            this.assertIsOwnedByUserHelper(repositoryUserName, taskOwner, null, expected);
            this.assertIsOwnedByUserHelper(repositoryUserName, taskOwner, "", expected);
        } else {
            this.assertIsOwnedByUserHelper(repositoryUserName, taskOwner, taskOwnerId, expected);
        }
    }

    private void assertIsOwnedByUserHelper(String repositoryUserName, String taskOwner, String taskOwnerId, boolean expected) {
        TaskRepository repository = new TaskRepository("mock-with-url", "http://mock-repo.com");
        if (repositoryUserName != null) {
            repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(repositoryUserName, ""), false);
        }
        this.taskWithUrl.setOwner(taskOwner);
        this.taskWithUrl.setOwnerId(taskOwnerId);
        AbstractRepositoryConnectorTest.assertEquals((boolean)expected, (boolean)this.connectorWithUrl.isOwnedByUser(repository, (ITask)this.taskWithUrl));
    }
}

