/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.net.InetSocketAddress;
import java.net.Proxy;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.commons.net.AuthenticatedProxy;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryLocationTest
extends TestCase {
    public void testGetCredentials() {
        TaskRepository taskRepository = new TaskRepository("kind", "http://url");
        taskRepository.flushAuthenticationCredentials();
        TaskRepositoryLocation location = new TaskRepositoryLocation(taskRepository);
        TaskRepositoryLocationTest.assertNull((Object)location.getCredentials(AuthenticationType.HTTP));
        taskRepository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("user", "pwd"), true);
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.HTTP);
        TaskRepositoryLocationTest.assertNotNull((Object)credentials);
        TaskRepositoryLocationTest.assertEquals((String)"user", (String)credentials.getUserName());
        TaskRepositoryLocationTest.assertEquals((String)"pwd", (String)credentials.getPassword());
        TaskRepositoryLocationTest.assertNull((Object)location.getCredentials(AuthenticationType.PROXY));
        taskRepository.setCredentials(AuthenticationType.PROXY, new AuthenticationCredentials("user2", "pwd2"), true);
        credentials = location.getCredentials(AuthenticationType.PROXY);
        TaskRepositoryLocationTest.assertNotNull((Object)credentials);
        TaskRepositoryLocationTest.assertEquals((String)"user2", (String)credentials.getUserName());
        TaskRepositoryLocationTest.assertEquals((String)"pwd2", (String)credentials.getPassword());
    }

    public void testGetProxyForHost() {
        Proxy defaultProxy = WebUtil.getProxy((String)"localhost", (String)"HTTP");
        TaskRepository taskRepository = new TaskRepository("kind", "http://url");
        TaskRepositoryLocation location = new TaskRepositoryLocation(taskRepository);
        TaskRepositoryLocationTest.assertTrue((boolean)taskRepository.isDefaultProxyEnabled());
        TaskRepositoryLocationTest.assertEquals((Object)defaultProxy, (Object)location.getProxyForHost("localhost", "HTTP"));
        taskRepository.setDefaultProxyEnabled(false);
        TaskRepositoryLocationTest.assertFalse((boolean)taskRepository.isDefaultProxyEnabled());
        TaskRepositoryLocationTest.assertEquals((Object)defaultProxy, (Object)location.getProxyForHost("localhost", "HTTP"));
        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", "host");
        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", "1234");
        Proxy proxy = location.getProxyForHost("localhost", "HTTP");
        TaskRepositoryLocationTest.assertNotNull((Object)proxy);
        TaskRepositoryLocationTest.assertEquals((Object)new InetSocketAddress("host", 1234), (Object)proxy.address());
        taskRepository.setCredentials(AuthenticationType.PROXY, new AuthenticationCredentials("user", "pwd"), false);
        proxy = location.getProxyForHost("localhost", "HTTP");
        TaskRepositoryLocationTest.assertNotNull((Object)proxy);
        TaskRepositoryLocationTest.assertEquals((Object)new InetSocketAddress("host", 1234), (Object)proxy.address());
        TaskRepositoryLocationTest.assertTrue((boolean)(proxy instanceof AuthenticatedProxy));
        TaskRepositoryLocationTest.assertEquals((String)"user", (String)((AuthenticatedProxy)proxy).getUserName());
        TaskRepositoryLocationTest.assertEquals((String)"pwd", (String)((AuthenticatedProxy)proxy).getPassword());
    }

    public void testGetProxyForHostEmptyProxy() {
        Proxy defaultProxy = WebUtil.getProxy((String)"localhost", (String)"HTTP");
        TaskRepository taskRepository = new TaskRepository("kind", "http://url");
        TaskRepositoryLocation location = new TaskRepositoryLocation(taskRepository);
        taskRepository.setDefaultProxyEnabled(false);
        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", "");
        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", "");
        TaskRepositoryLocationTest.assertEquals((Object)defaultProxy, (Object)location.getProxyForHost("localhost", "HTTP"));
        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", "");
        taskRepository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", "abc");
        TaskRepositoryLocationTest.assertEquals((Object)defaultProxy, (Object)location.getProxyForHost("localhost", "HTTP"));
    }

    public void testRequestCredentials() {
        TaskRepository taskRepository = new TaskRepository("kind", "http://url");
        TaskRepositoryLocation location = new TaskRepositoryLocation(taskRepository);
        try {
            location.requestCredentials(AuthenticationType.REPOSITORY, null, null);
            TaskRepositoryLocationTest.fail((String)"Expected UnsupportedRequestException");
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            // empty catch block
        }
    }
}

