/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import com.google.common.collect.ImmutableSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.BrandManager;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BrandManagerTest {
    private final BrandManager brandManager = new BrandManager();

    @Test
    public void testGetConnectorLabel() {
        MockRepositoryConnector mock1 = this.connector("mock1");
        MockRepositoryConnector mock2 = this.connector("mock2");
        this.brandManager.addConnectorLabel("mock1", "org.mylyn", "Mylyn");
        this.brandManager.addConnectorLabel("mock1", "org.eclipse", "Eclipse");
        this.brandManager.addConnectorLabel("mock2", "org.mylyn", "Mylyn");
        this.brandManager.addConnectorLabel("mock2", "com.acme", "ACME");
        this.assertBrands();
        Assert.assertEquals((Object)"Mylyn", (Object)this.brandManager.getConnectorLabel((AbstractRepositoryConnector)mock1, "org.mylyn"));
        Assert.assertEquals((Object)"Eclipse", (Object)this.brandManager.getConnectorLabel((AbstractRepositoryConnector)mock1, "org.eclipse"));
        Assert.assertEquals((Object)"Mylyn", (Object)this.brandManager.getConnectorLabel((AbstractRepositoryConnector)mock2, "org.mylyn"));
        Assert.assertEquals((Object)"ACME", (Object)this.brandManager.getConnectorLabel((AbstractRepositoryConnector)mock2, "com.acme"));
        Assert.assertEquals((Object)mock2.getLabel(), (Object)this.brandManager.getConnectorLabel((AbstractRepositoryConnector)mock2, "org.eclipse"));
        Assert.assertEquals((Object)mock2.getLabel(), (Object)this.brandManager.getConnectorLabel((AbstractRepositoryConnector)mock2, null));
    }

    @Test
    public void testGetBrandingIcon() {
        this.brandManager.addBrandingIcon("mock1", "org.mylyn", this.image(1));
        this.brandManager.addBrandingIcon("mock1", "org.eclipse", new Image((Device)Display.getCurrent(), 2, 2));
        this.brandManager.addBrandingIcon("mock2", "org.mylyn", new Image((Device)Display.getCurrent(), 3, 3));
        this.brandManager.addBrandingIcon("mock2", "com.acme", new Image((Device)Display.getCurrent(), 4, 4));
        this.assertBrands();
        this.assertBrandingIconHeight(1, "mock1", "org.mylyn");
        this.assertBrandingIconHeight(2, "mock1", "org.eclipse");
        this.assertBrandingIconHeight(3, "mock2", "org.mylyn");
        this.assertBrandingIconHeight(4, "mock2", "com.acme");
        Assert.assertEquals(null, (Object)this.brandManager.getBrandingIcon("mock2", "org.eclipse"));
        Assert.assertEquals(null, (Object)this.brandManager.getBrandingIcon(this.repository("mock2", "org.eclipse")));
        Assert.assertEquals(null, (Object)this.brandManager.getBrandingIcon("mock2", null));
        Assert.assertEquals(null, (Object)this.brandManager.getBrandingIcon(this.repository("mock2", null)));
        this.brandManager.addDefaultBrandingIcon("mock2", new Image((Device)Display.getCurrent(), 5, 5));
        Assert.assertEquals((long)5L, (long)this.brandManager.getBrandingIcon((String)"mock2", (String)"org.eclipse").getImageData().height);
        Assert.assertEquals((long)5L, (long)this.brandManager.getBrandingIcon((TaskRepository)this.repository((String)"mock2", (String)"org.eclipse")).getImageData().height);
        Assert.assertEquals((long)5L, (long)this.brandManager.getBrandingIcon((String)"mock2", null).getImageData().height);
        Assert.assertEquals((long)5L, (long)this.brandManager.getBrandingIcon((TaskRepository)this.repository((String)"mock2", null)).getImageData().height);
    }

    private void assertBrandingIconHeight(int expectedHeight, String connectorKind, String brand) {
        Assert.assertEquals((long)expectedHeight, (long)this.brandManager.getBrandingIcon((String)connectorKind, (String)brand).getImageData().height);
        Assert.assertEquals((long)expectedHeight, (long)this.brandManager.getBrandingIcon((TaskRepository)this.repository((String)connectorKind, (String)brand)).getImageData().height);
    }

    private TaskRepository repository(String connectorKind, String brand) {
        TaskRepository repository = new TaskRepository(connectorKind, "http://mock");
        repository.setProperty("org.eclipse.mylyn.brand.id", brand);
        return repository;
    }

    @Test
    public void testGetOverlayIcon() {
        this.brandManager.addOverlayIcon("mock1", "org.mylyn", this.imageDescriptor(1));
        this.brandManager.addOverlayIcon("mock1", "org.eclipse", this.imageDescriptor(2));
        this.brandManager.addOverlayIcon("mock2", "org.mylyn", this.imageDescriptor(3));
        this.brandManager.addOverlayIcon("mock2", "com.acme", this.imageDescriptor(4));
        this.assertBrands();
        this.assertOverlayIconHeight(1, "mock1", "org.mylyn");
        this.assertOverlayIconHeight(2, "mock1", "org.eclipse");
        this.assertOverlayIconHeight(3, "mock2", "org.mylyn");
        this.assertOverlayIconHeight(4, "mock2", "com.acme");
        Assert.assertEquals(null, (Object)this.brandManager.getOverlayIcon("mock2", "org.eclipse"));
        Assert.assertEquals(null, (Object)this.brandManager.getOverlayIcon(this.repository("mock2", "org.eclipse")));
        Assert.assertEquals(null, (Object)this.brandManager.getOverlayIcon("mock2", null));
        Assert.assertEquals(null, (Object)this.brandManager.getOverlayIcon(this.repository("mock2", null)));
        this.brandManager.addDefaultOverlayIcon("mock2", this.imageDescriptor(5));
        Assert.assertEquals((long)5L, (long)this.brandManager.getOverlayIcon((String)"mock2", (String)"org.eclipse").getImageData().height);
        Assert.assertEquals((long)5L, (long)this.brandManager.getOverlayIcon((TaskRepository)this.repository((String)"mock2", (String)"org.eclipse")).getImageData().height);
        Assert.assertEquals((long)5L, (long)this.brandManager.getOverlayIcon((String)"mock2", null).getImageData().height);
        Assert.assertEquals((long)5L, (long)this.brandManager.getOverlayIcon((TaskRepository)this.repository((String)"mock2", null)).getImageData().height);
    }

    private void assertOverlayIconHeight(int expectedHeight, String connectorKind, String brand) {
        Assert.assertEquals((long)expectedHeight, (long)this.brandManager.getOverlayIcon((String)connectorKind, (String)brand).getImageData().height);
        Assert.assertEquals((long)expectedHeight, (long)this.brandManager.getOverlayIcon((TaskRepository)this.repository((String)connectorKind, (String)brand)).getImageData().height);
    }

    private void assertBrands() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"org.mylyn", (Object)"org.eclipse"), (Object)this.brandManager.getBrands("mock1"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"org.mylyn", (Object)"com.acme"), (Object)this.brandManager.getBrands("mock2"));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)this.brandManager.getBrands("unknown"));
    }

    private Image image(int size) {
        return new Image((Device)Display.getCurrent(), size, size);
    }

    private ImageDescriptor imageDescriptor(int size) {
        ImageDescriptor mock = (ImageDescriptor)Mockito.mock(ImageDescriptor.class);
        ImageData data = new ImageData(size, size, 1, new PaletteData(1, 1, 1));
        Mockito.when((Object)mock.getImageData()).thenReturn((Object)data);
        return mock;
    }

    private MockRepositoryConnector connector(final String kind) {
        return new MockRepositoryConnector(){

            public String getConnectorKind() {
                return kind;
            }
        };
    }
}

