/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.AbstractAgreement;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountGroup;
import com.google.gerrit.reviewdb.ContributorAgreement;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import java.sql.Timestamp;

public final class AccountGroupAgreement
implements AbstractAgreement {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected Timestamp acceptedOn;
    @Column(id=3)
    protected char status;
    @Column(id=4, notNull=false)
    protected Account.Id reviewedBy;
    @Column(id=5, notNull=false)
    protected Timestamp reviewedOn;
    @Column(id=6, notNull=false, length=0x7FFFFFFF)
    protected String reviewComments;

    protected AccountGroupAgreement() {
    }

    public AccountGroupAgreement(Key k) {
        this.key = k;
        this.acceptedOn = new Timestamp(System.currentTimeMillis());
        this.status = AbstractAgreement.Status.NEW.getCode();
    }

    public Key getKey() {
        return this.key;
    }

    @Override
    public ContributorAgreement.Id getAgreementId() {
        return this.key.claId;
    }

    @Override
    public Timestamp getAcceptedOn() {
        return this.acceptedOn;
    }

    @Override
    public AbstractAgreement.Status getStatus() {
        return AbstractAgreement.Status.forCode(this.status);
    }

    @Override
    public Timestamp getReviewedOn() {
        return this.reviewedOn;
    }

    @Override
    public Account.Id getReviewedBy() {
        return this.reviewedBy;
    }

    @Override
    public String getReviewComments() {
        return this.reviewComments;
    }

    public void setReviewComments(String s) {
        this.reviewComments = s;
    }

    public static class Key
    extends CompoundKey<AccountGroup.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected AccountGroup.Id groupId;
        @Column(id=2)
        protected ContributorAgreement.Id claId;

        protected Key() {
            this.groupId = new AccountGroup.Id();
            this.claId = new ContributorAgreement.Id();
        }

        public Key(AccountGroup.Id group, ContributorAgreement.Id cla) {
            this.groupId = group;
            this.claId = cla;
        }

        public AccountGroup.Id getParentKey() {
            return this.groupId;
        }

        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.claId};
        }
    }
}

