/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

public class TaskListSynchronizationScheduler
implements IUserAttentionListener {
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.tasks.ui/debug/synchronization"));
    private long interval;
    private long inactiveInterval;
    private final SynchronizationJob refreshJob;
    private boolean userActive = true;
    private long scheduledTime;
    private long lastSyncTime;
    private final JobChangeAdapter jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            TaskListSynchronizationScheduler.this.jobDone();
        }
    };

    public TaskListSynchronizationScheduler(ITaskJobFactory jobFactory) {
        this.refreshJob = jobFactory.createSynchronizeRepositoriesJob(null);
        this.refreshJob.setSystem(true);
        this.refreshJob.setUser(false);
        this.refreshJob.setFullSynchronization(true);
    }

    public synchronized SynchronizationJob getRefreshJob() {
        return this.refreshJob;
    }

    private synchronized void reschedule() {
        long delay = this.interval;
        if (delay != 0L) {
            if (!this.userActive) {
                this.inactiveInterval *= 3L;
                delay = this.inactiveInterval;
                if (TRACE_ENABLED) {
                    this.trace("Set inactive interval to " + DateUtil.getFormattedDurationShort((long)this.inactiveInterval));
                }
            }
            if (this.scheduledTime != 0L) {
                if (this.scheduledTime < System.currentTimeMillis() + delay) {
                    if (TRACE_ENABLED) {
                        this.trace("Synchronization already scheduled in " + DateUtil.getFormattedDurationShort((long)(this.scheduledTime - System.currentTimeMillis())));
                    }
                    return;
                }
                this.cancel();
            }
            this.schedule(delay);
        }
    }

    private synchronized void cancel() {
        if (TRACE_ENABLED) {
            this.trace("Canceling synchronization scheduled to run in " + DateUtil.getFormattedDurationShort((long)(this.scheduledTime - System.currentTimeMillis())));
        }
        this.refreshJob.removeJobChangeListener((IJobChangeListener)this.jobListener);
        this.refreshJob.cancel();
        this.refreshJob.addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    private void schedule(long interval) {
        if (TRACE_ENABLED) {
            this.trace("Scheduling synchronization in " + DateUtil.getFormattedDurationShort((long)interval));
        }
        this.scheduledTime = System.currentTimeMillis() + interval;
        this.refreshJob.schedule(interval);
    }

    public synchronized void setInterval(long interval) {
        this.setInterval(interval, interval);
    }

    public synchronized void setInterval(long delay, long interval) {
        if (this.interval != interval) {
            this.interval = interval;
            this.inactiveInterval = interval;
            this.scheduledTime = 0L;
            this.cancel();
            if (interval > 0L) {
                this.schedule(delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAttentionGained() {
        TaskListSynchronizationScheduler taskListSynchronizationScheduler = this;
        synchronized (taskListSynchronizationScheduler) {
            if (!this.userActive) {
                if (TRACE_ENABLED) {
                    this.trace("User activity detected");
                }
                this.userActive = true;
                this.inactiveInterval = this.interval;
                if (this.interval != 0L) {
                    if (System.currentTimeMillis() - this.lastSyncTime > this.interval) {
                        this.cancel();
                        this.schedule(0L);
                    } else {
                        this.reschedule();
                    }
                }
            }
        }
    }

    private void trace(String message) {
        System.err.println("[" + new Date() + "] " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAttentionLost() {
        TaskListSynchronizationScheduler taskListSynchronizationScheduler = this;
        synchronized (taskListSynchronizationScheduler) {
            this.userActive = false;
        }
    }

    synchronized void jobDone() {
        this.scheduledTime = 0L;
        this.lastSyncTime = System.currentTimeMillis();
        this.reschedule();
    }
}

