/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.provisional.commons.ui.IFilteredTreeListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

@Deprecated
public class AdaptiveRefreshPolicy {
    private int refreshDelay = 1500;
    private final Set<IFilteredTreeListener> listeners = new HashSet<IFilteredTreeListener>();
    private String oldText = "";
    protected Job refreshJob;
    protected final IJobChangeListener REFRESH_JOB_LISTENER = new IJobChangeListener(){

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        for (IFilteredTreeListener listener : AdaptiveRefreshPolicy.this.listeners) {
                            listener.filterTextChanged(AdaptiveRefreshPolicy.this.oldText);
                        }
                    }
                });
            }
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    };

    @Deprecated
    public AdaptiveRefreshPolicy(Job refreshJob, Text filterText) {
        this(refreshJob);
    }

    public AdaptiveRefreshPolicy(Job refreshJob) {
        Assert.isNotNull((Object)refreshJob);
        this.refreshJob = refreshJob;
        refreshJob.addJobChangeListener(this.REFRESH_JOB_LISTENER);
    }

    public void dispose() {
        this.refreshJob.removeJobChangeListener(this.REFRESH_JOB_LISTENER);
    }

    public void textChanged(String text) {
        if (text == null || text.equals(this.oldText)) {
            return;
        }
        this.refreshJob.cancel();
        int delay = 0;
        int textLength = text.length();
        if (textLength > 0) {
            delay = (int)((double)this.refreshDelay / ((double)textLength * 0.6));
        }
        this.refreshJob.schedule((long)delay);
        this.oldText = text;
    }

    public void filterChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule((long)(this.refreshDelay / 2));
    }

    public void internalForceRefresh() {
        ((WorkbenchJob)this.refreshJob).runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    public void addListener(IFilteredTreeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFilteredTreeListener listener) {
        this.listeners.remove(listener);
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }
}

