/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.provisional.commons.ui.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

@Deprecated
public class DatePickerPanel
extends Composite
implements KeyListener,
ISelectionProvider {
    private org.eclipse.swt.widgets.List timeList = null;
    private ISelection selection = null;
    private Calendar date = null;
    private DateTime calendar = null;
    private final List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private int hourOfDay = 0;

    public DatePickerPanel(Composite parent, int style, Calendar initialDate, boolean includeTime, int hourOfDay) {
        this(parent, style, initialDate, includeTime, hourOfDay, -1);
    }

    public DatePickerPanel(Composite parent, int style, Calendar initialDate, boolean includeTime, int hourOfDay, int marginSize) {
        super(parent, style);
        this.date = initialDate;
        this.hourOfDay = hourOfDay;
        this.initialize(includeTime, marginSize);
        this.setDate(this.date);
    }

    private void initialize(boolean includeTime, int marginSize) {
        if (this.date == null) {
            this.date = Calendar.getInstance();
            this.date.set(11, this.hourOfDay);
            this.date.set(12, 0);
            this.date.set(13, 0);
            this.date.set(14, 0);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = includeTime ? 2 : 1;
        if (marginSize != -1) {
            gridLayout.marginWidth = marginSize;
        }
        this.setLayout((Layout)gridLayout);
        this.calendar = new DateTime((Composite)this, 1024);
        this.calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DatePickerPanel.this.date.set(1, DatePickerPanel.this.calendar.getYear());
                DatePickerPanel.this.date.set(2, DatePickerPanel.this.calendar.getMonth());
                DatePickerPanel.this.date.set(5, DatePickerPanel.this.calendar.getDay());
                DatePickerPanel.this.setSelection(new DateSelection(DatePickerPanel.this.date, true));
                DatePickerPanel.this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)DatePickerPanel.this, DatePickerPanel.this.getSelection()));
            }

            public void widgetSelected(SelectionEvent e) {
                DatePickerPanel.this.date.set(1, DatePickerPanel.this.calendar.getYear());
                DatePickerPanel.this.date.set(2, DatePickerPanel.this.calendar.getMonth());
                DatePickerPanel.this.date.set(5, DatePickerPanel.this.calendar.getDay());
                DatePickerPanel.this.setSelection(new DateSelection(DatePickerPanel.this.date));
                DatePickerPanel.this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)DatePickerPanel.this, DatePickerPanel.this.getSelection()));
            }
        });
        if (includeTime) {
            this.createTimeList(this);
        }
        Hyperlink todayLink = new Hyperlink((Composite)this, 0);
        todayLink.setText(Messages.DatePickerPanel_Today);
        todayLink.setUnderlined(true);
        todayLink.setForeground(CommonColors.HYPERLINK_WIDGET);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).align(0x1000000, 128).applyTo((Control)todayLink);
        todayLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Calendar selectedDate;
                Calendar today = Calendar.getInstance();
                ISelection selection = DatePickerPanel.this.getSelection();
                if (selection instanceof DateSelection && !selection.isEmpty() && (selectedDate = ((DateSelection)selection).getDate()) != null) {
                    today.set(11, selectedDate.get(11));
                    today.set(12, selectedDate.get(12));
                    today.set(13, selectedDate.get(13));
                    today.set(14, selectedDate.get(14));
                }
                DatePickerPanel.this.setDate(today, true);
            }
        });
    }

    private void createTimeList(Composite composite) {
        DateFormat dateFormat = DateFormat.getTimeInstance(3);
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.set(12, 0);
        tempCalendar.set(13, 0);
        String[] times = new String[24];
        int x = 0;
        while (x < 24) {
            String timeString;
            tempCalendar.set(11, x);
            times[x] = timeString = dateFormat.format(tempCalendar.getTime());
            ++x;
        }
        ListViewer listViewer = new ListViewer(composite);
        listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        listViewer.setInput((Object)times);
        this.timeList = listViewer.getList();
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DatePickerPanel.this.date.set(11, DatePickerPanel.this.timeList.getSelectionIndex());
                DatePickerPanel.this.date.set(12, 0);
                DatePickerPanel.this.setSelection(new DateSelection(DatePickerPanel.this.date));
                DatePickerPanel.this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)DatePickerPanel.this, DatePickerPanel.this.getSelection()));
            }
        });
        listViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                DatePickerPanel.this.date.set(11, DatePickerPanel.this.timeList.getSelectionIndex());
                DatePickerPanel.this.date.set(12, 0);
                DatePickerPanel.this.setSelection(new DateSelection(DatePickerPanel.this.date, true));
                DatePickerPanel.this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)DatePickerPanel.this, DatePickerPanel.this.getSelection()));
            }
        });
        GridDataFactory.fillDefaults().hint(-1, 50).applyTo((Control)this.timeList);
        if (this.date != null) {
            listViewer.setSelection((ISelection)new StructuredSelection((Object)times[this.date.get(11)]), true);
        } else {
            listViewer.setSelection((ISelection)new StructuredSelection((Object)times[8]), true);
        }
        this.timeList.addKeyListener((KeyListener)this);
    }

    public void setDate(Calendar date) {
        this.setDate(date, false);
    }

    public void setDate(Calendar date, boolean notifyListeners) {
        this.date = date;
        this.calendar.setYear(date.get(1));
        this.calendar.setMonth(date.get(2));
        this.calendar.setDay(date.get(5));
        if (notifyListeners) {
            this.setSelection(new DateSelection(date, false));
            this.notifyListeners(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 27) {
            SelectionChangedEvent changeEvent = new SelectionChangedEvent((ISelectionProvider)this, new ISelection(){

                public boolean isEmpty() {
                    return true;
                }
            });
            this.notifyListeners(changeEvent);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void notifyListeners(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public class DateSelection
    implements ISelection {
        private final Calendar date;
        private final boolean isDefaultSelection;

        public DateSelection(Calendar calendar) {
            this(calendar, false);
        }

        public DateSelection(Calendar calendar, boolean isDefaultSelection) {
            this.date = calendar;
            this.isDefaultSelection = isDefaultSelection;
        }

        public boolean isEmpty() {
            return this.date == null;
        }

        public boolean isDefaultSelection() {
            return this.isDefaultSelection;
        }

        public Calendar getDate() {
            return this.date;
        }
    }
}

