/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui.dialogs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.provisional.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

@Deprecated
public class WebBrowserDialog
extends MessageDialog {
    private String text;
    private Browser browser;
    private Label statusLabel;

    public WebBrowserDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.setShellStyle(1264);
    }

    public void setText(String text) {
        this.text = text;
        if (this.browser != null) {
            this.browser.setText(text);
        }
    }

    public String getText() {
        return this.text;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        try {
            Method method = Browser.class.getDeclaredMethod("setUrl", String.class, String.class, String[].class);
            return (Boolean)method.invoke((Object)this.getBrowser(), url, postData, headers);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int openText(Shell parent, String title, String message, String text) {
        if (PlatformUiUtil.hasInternalBrowser()) {
            WebBrowserDialog dialog = new WebBrowserDialog(parent, title, null, message, 0, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.setText(text);
            return dialog.open();
        }
        File file = null;
        try {
            file = File.createTempFile("temp", ".html");
            file.deleteOnExit();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            try {
                writer.write(message);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", "Unexpected error while displaying page", (Throwable)e), 1);
            return 1;
        }
        WorkbenchUtil.openUrl(file.toURI().toString(), 128);
        return 0;
    }

    public Control createCustomArea(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.browser = new Browser(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.browser);
        this.statusLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.statusLabel);
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                WebBrowserDialog.this.statusLabel.setText(event.text != null ? event.text : "");
            }
        });
        if (this.text != null) {
            this.browser.setText(this.text);
        }
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }
}

