/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.AbstractMediaWikiLanguage;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.TemplateProcessor;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.Template;
import org.eclipse.mylyn.wikitext.mediawiki.core.TemplateResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateProcessorTest
extends TestCase {
    private MediaWikiLanguage markupLanguage;

    protected void setUp() throws Exception {
        this.markupLanguage = new MediaWikiLanguage();
    }

    public void testBasicTemplateNoParameters() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("_expanded_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test}} two");
        TemplateProcessorTest.assertEquals((String)"one _expanded_ two", (String)markup);
    }

    public void testBasicTemplateNamedParameter() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("_expanded{{{message}}}_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test|message=foo bar}} two");
        TemplateProcessorTest.assertEquals((String)"one _expandedfoo bar_ two", (String)markup);
    }

    public void testBasicTemplatePositionalParameter() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("_expanded{{{1}}}and{{{2}}}and{{{1}}}_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test|one|two}} two");
        TemplateProcessorTest.assertEquals((String)"one _expandedoneandtwoandone_ two", (String)markup);
    }

    public void testBasicTemplatePositionalParameterWithSpaces() {
        Template template = new Template();
        template.setName("Note");
        template.setTemplateMarkup("<p class='note'>{{{1}}}</p>");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{Note|comment with spaces.}} two");
        TemplateProcessorTest.assertEquals((String)"one <p class='note'>comment with spaces.</p> two", (String)markup);
    }

    public void testBasicTemplateNamedParameterMissingValue() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("_expanded{{{message}}}_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test}} two");
        TemplateProcessorTest.assertEquals((String)"one _expanded_ two", (String)markup);
    }

    public void testBasicTemplateNamedParameterMultiple() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("_expanded{{{message}}}and{{{message2}}}_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test|message=foo bar|message2=baz}} two");
        TemplateProcessorTest.assertEquals((String)"one _expandedfoo barandbaz_ two", (String)markup);
    }

    public void testBasicTemplateQualifiedName() {
        Template template = new Template();
        template.setName("Test:test");
        template.setTemplateMarkup("_expanded_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{Test:test}} two");
        TemplateProcessorTest.assertEquals((String)"one _expanded_ two", (String)markup);
    }

    public void testBasicTemplateIncludeonly() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("foo bar baz\n<includeonly>_expanded_</includeonly>");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test}} two");
        TemplateProcessorTest.assertEquals((String)"one _expanded_ two", (String)markup);
    }

    public void testBasicTemplateNoInclude() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("<noinclude>foo bar baz\n</noinclude>_expanded_");
        this.markupLanguage.getTemplates().add(template);
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test}} two");
        TemplateProcessorTest.assertEquals((String)"one _expanded_ two", (String)markup);
    }

    public void testBasicTemplateExcluded() {
        Template template = new Template();
        template.setName("test");
        template.setTemplateMarkup("_expanded_");
        this.markupLanguage.getTemplates().add(template);
        this.markupLanguage.setTemplateExcludes("boo, baz, test");
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{test}} two");
        TemplateProcessorTest.assertEquals((String)"one  two", (String)markup);
    }

    public void testBasicTemplateExcluded2() {
        Template template = new Template();
        template.setName("testBar");
        template.setTemplateMarkup("_expanded_");
        this.markupLanguage.getTemplates().add(template);
        this.markupLanguage.setTemplateExcludes("boo, baz, test*");
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{testBar}} two");
        TemplateProcessorTest.assertEquals((String)"one  two", (String)markup);
    }

    public void testBasicTemplateExcludedWithWildcards() {
        Template template = new Template();
        template.setName("Foo:test");
        template.setTemplateMarkup("_expanded_");
        this.markupLanguage.getTemplates().add(template);
        this.markupLanguage.setTemplateExcludes("boo, baz, *test*");
        TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
        String markup = templateProcessor.processTemplates("one {{Foo:test}} two");
        TemplateProcessorTest.assertEquals((String)"one  two", (String)markup);
    }

    public void testCaseSensitivity() {
        String[] names;
        final HashSet<String> templateNames = new HashSet<String>();
        this.markupLanguage.getTemplateProviders().add(new TemplateResolver(){

            public Template resolveTemplate(String templateName) {
                templateNames.add(templateName);
                Template template = new Template();
                template.setName(templateName);
                template.setTemplateMarkup("test");
                return template;
            }
        });
        String[] stringArray = names = new String[]{"One", "one", "OneTwo", "onetwo", "oneTwo"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            templateNames.clear();
            TemplateProcessor templateProcessor = new TemplateProcessor((AbstractMediaWikiLanguage)this.markupLanguage);
            templateProcessor.processTemplates("content {{" + name + "}} more");
            this.assertContains(templateNames, name);
            TemplateProcessorTest.assertEquals((int)1, (int)templateNames.size());
            ++n2;
        }
    }

    private void assertContains(Set<String> strings, String string) {
        TemplateProcessorTest.assertTrue((String)String.format("Expected %s but got %s", string, strings), (boolean)strings.contains(string));
    }
}

