/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.util.LocationTrackingReader;

public class LocationTrackingReaderTest
extends TestCase {
    public void testCharOffset() throws IOException {
        int c;
        String content = "aaflkjsdf \nas;dfj asl;fj\r\naslfkjasd";
        int count = 0;
        LocationTrackingReader reader = new LocationTrackingReader((Reader)new StringReader(content), 16);
        while ((c = reader.read()) != -1) {
            LocationTrackingReaderTest.assertEquals((char)content.charAt(++count - 1), (char)((char)c));
            LocationTrackingReaderTest.assertEquals((int)(count - 1), (int)reader.getOffset());
        }
        LocationTrackingReaderTest.assertEquals((int)content.length(), (int)count);
    }

    public void testReadLine() throws IOException {
        String content = "\rabc\ndef\r\rfoo bar";
        int bufSize = 3;
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 5;
        nArray[3] = 9;
        nArray[4] = 10;
        nArray[5] = 17;
        int[] lineOffsets = nArray;
        this.doTest(content, lineOffsets, bufSize);
    }

    private void doTest(String content, int[] lineOffsets, int bufSize) throws IOException {
        LocationTrackingReader reader = new LocationTrackingReader((Reader)new StringReader(content), bufSize);
        BufferedReader refReader = new BufferedReader(new StringReader(content));
        int lineNumber = 0;
        String testLine = null;
        String refLine = null;
        do {
            int expectedOffset = lineOffsets[lineNumber++];
            testLine = reader.readLine();
            refLine = refReader.readLine();
            LocationTrackingReaderTest.assertEquals((String)refLine, (String)testLine);
            LocationTrackingReaderTest.assertEquals((int)expectedOffset, (int)reader.getLineOffset());
            LocationTrackingReaderTest.assertEquals((int)(lineNumber - 1), (int)reader.getLineNumber());
        } while (testLine != null && refLine != null);
        LocationTrackingReaderTest.assertTrue((refLine == null ? 1 : 0) != 0);
        LocationTrackingReaderTest.assertTrue((testLine == null ? 1 : 0) != 0);
    }

    public void testReadLineWithWindowsNewlines() throws IOException {
        String content = "abc\r\ndef\r\n\r\nfoo bar";
        int bufSize = 3;
        int[] nArray = new int[5];
        nArray[1] = 5;
        nArray[2] = 10;
        nArray[3] = 12;
        nArray[4] = 19;
        int[] lineOffsets = nArray;
        this.doTest(content, lineOffsets, bufSize);
    }

    public void testReadLineWithTerminatingEOLs() throws IOException {
        String content = "abc\n";
        int bufSize = 3;
        int[] nArray = new int[2];
        nArray[1] = 4;
        int[] lineOffsets = nArray;
        this.doTest(content, lineOffsets, bufSize);
        content = "abc\r\n";
        bufSize = 3;
        int[] nArray2 = new int[2];
        nArray2[1] = 5;
        lineOffsets = nArray2;
        this.doTest(content, lineOffsets, bufSize);
        content = "abc\r";
        bufSize = 3;
        int[] nArray3 = new int[2];
        nArray3[1] = 4;
        lineOffsets = nArray3;
        this.doTest(content, lineOffsets, bufSize);
    }
}

