/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class ServiceLocatorTest
extends TestCase {
    private ServiceLocator locator;

    public void setUp() {
        this.locator = ServiceLocator.getInstance((ClassLoader)ServiceLocatorTest.class.getClassLoader());
    }

    public void testKnownLanguage() {
        MarkupLanguage markupLanguage;
        try {
            markupLanguage = this.locator.getMarkupLanguage("Textile");
        }
        catch (IllegalArgumentException e) {
            ServiceLocatorTest.fail((String)(String.valueOf(e.getMessage()) + " NOTE: THIS TEST WILL FAIL IF THE CLASSES UNDER TEST ARE NOT IN A JAR"));
            return;
        }
        ServiceLocatorTest.assertNotNull((Object)markupLanguage);
    }

    public void testUnknownLanguage() {
        try {
            this.locator.getMarkupLanguage("No Such Language asdlkfjal;sjdf");
            ServiceLocatorTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException e) {
            TestUtil.println(e.getMessage());
        }
    }

    public void testFQN() {
        MarkupLanguage markupLanguage = this.locator.getMarkupLanguage(TextileLanguage.class.getName());
        ServiceLocatorTest.assertNotNull((Object)markupLanguage);
    }
}

