/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import org.eclipse.mylyn.wikitext.core.util.anttask.AbstractTestAntTask;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupToDitaTask;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class MarkupToDitaTaskTest
extends AbstractTestAntTask {
    private MarkupToDitaTask ditaTask;
    private File topicsFolder;

    protected void setUp() throws Exception {
        super.setUp();
        this.ditaTask = new MarkupToDitaTask();
        this.ditaTask.setMarkupLanguage(this.languageName);
        this.topicsFolder = new File(this.tempFolder, this.ditaTask.getTopicFolder());
        this.topicsFolder.mkdirs();
    }

    private File createSimpleTextileMarkup() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        PrintWriter writer = new PrintWriter(new FileWriter(markupFile));
        try {
            writer.println("h1. First Heading");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
        }
        finally {
            writer.close();
        }
        return markupFile;
    }

    private File createTextileMarkupWithXref() throws IOException {
        return this.createTextileMarkupWithXref(1);
    }

    private File createTextileMarkupWithXref(int headingLevel) throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        PrintWriter writer = new PrintWriter(new FileWriter(markupFile));
        try {
            writer.println("h" + headingLevel + "(#Id1). First Heading");
            writer.println();
            writer.println("some content with a \"ref to 2\":#Id2");
            writer.println();
            writer.println("h" + headingLevel + "(#Id2). Second Heading");
            writer.println();
            writer.println("some more content with with a \"ref to 1\":#Id1 and a \"ref to 2\":#Id2");
        }
        finally {
            writer.close();
        }
        return markupFile;
    }

    private File createSimpleTextileMarkupWithFQNHeadings() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        PrintWriter writer = new PrintWriter(new FileWriter(markupFile));
        try {
            writer.println("h1. " + MarkupToDitaTaskTest.class.getName());
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
        }
        finally {
            writer.close();
        }
        return markupFile;
    }

    public void testCreatesMapbook() throws IOException {
        File markupFile = this.createSimpleTextileMarkup();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.topicsFolder, "FirstHeading.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        File secondHeadingFile = new File(this.topicsFolder, "SecondHeading.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)secondHeadingFile.exists());
        String ditamapContent = this.getContent(ditamapFile);
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<bookmap>"));
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<chapter href=\"topics/FirstHeading.dita\" navtitle=\"First Heading\"/>"));
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<chapter href=\"topics/SecondHeading.dita\" navtitle=\"Second Heading\"/>"));
        String firstTopicContent = this.getContent(firstHeadingFile);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"FirstHeading\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>First Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<p>some content</p>"));
    }

    public void testCreatesMapbookNoFormatting() throws IOException {
        File markupFile = this.createSimpleTextileMarkup();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.setFormatting(false);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.topicsFolder, "FirstHeading.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        File secondHeadingFile = new File(this.topicsFolder, "SecondHeading.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)secondHeadingFile.exists());
        String ditamapContent = this.getContent(ditamapFile);
        TestUtil.println(ditamapContent);
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<bookmap><title>Sample Title</title><chapter href=\"topics/FirstHeading.dita\" navtitle=\"First Heading\"/><chapter href=\"topics/SecondHeading.dita\" navtitle=\"Second Heading\"/></bookmap>"));
        String firstTopicContent = this.getContent(firstHeadingFile);
        TestUtil.println(firstTopicContent);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"FirstHeading\"><title>First Heading</title><body><p>some content</p></body></topic>"));
    }

    public void testCreatesSingleTopic() throws IOException {
        File markupFile = this.createSimpleTextileMarkup();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.setFilenameFormat("$1.dita");
        this.ditaTask.setTopicStrategy(MarkupToDitaTask.BreakStrategy.NONE);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertFalse((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.tempFolder, "markup.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        String firstTopicContent = this.getContent(firstHeadingFile);
        TestUtil.println(firstTopicContent);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"FirstHeading\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>First Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<p>some content</p>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"SecondHeading\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>Second Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<p>some more content</p>"));
    }

    public void testCreatesSingleTopicNoFormatting() throws IOException {
        File markupFile = this.createSimpleTextileMarkup();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.setFilenameFormat("$1.dita");
        this.ditaTask.setTopicStrategy(MarkupToDitaTask.BreakStrategy.NONE);
        this.ditaTask.setFormatting(false);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertFalse((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.tempFolder, "markup.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        String firstTopicContent = this.getContent(firstHeadingFile);
        TestUtil.println(firstTopicContent);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic><title>Sample Title</title><topic id=\"FirstHeading\"><title>First Heading</title><body><p>some content</p></body></topic><topic id=\"SecondHeading\"><title>Second Heading</title><body><p>some more content</p></body></topic></topic>"));
    }

    public void testMapbookXRef() throws IOException {
        File markupFile = this.createTextileMarkupWithXref();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.execute();
        this.listFiles();
        File firstHeadingFile = new File(this.topicsFolder, "Id1.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        File secondHeadingFile = new File(this.topicsFolder, "Id2.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)secondHeadingFile.exists());
        String firstTopicContent = this.getContent(firstHeadingFile);
        String secondTopicContent = this.getContent(secondHeadingFile);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<xref href=\"Id2.dita#Id2\">ref to 2</xref>"));
        MarkupToDitaTaskTest.assertTrue((boolean)secondTopicContent.contains("<xref href=\"Id1.dita#Id1\">ref to 1</xref>"));
        MarkupToDitaTaskTest.assertTrue((boolean)secondTopicContent.contains("<xref href=\"#Id2\">ref to 2</xref>"));
    }

    public void testMapbookXRef_H2() throws IOException {
        File markupFile = this.createTextileMarkupWithXref(2);
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.setTopicStrategy(MarkupToDitaTask.BreakStrategy.FIRST);
        this.ditaTask.execute();
        this.listFiles();
        File firstHeadingFile = new File(this.topicsFolder, "Id1.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        File secondHeadingFile = new File(this.topicsFolder, "Id2.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)secondHeadingFile.exists());
        String firstTopicContent = this.getContent(firstHeadingFile);
        String secondTopicContent = this.getContent(secondHeadingFile);
        TestUtil.println(firstTopicContent);
        TestUtil.println(secondTopicContent);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<xref href=\"Id2.dita#Id2\">ref to 2</xref>"));
        MarkupToDitaTaskTest.assertTrue((boolean)secondTopicContent.contains("<xref href=\"Id1.dita#Id1\">ref to 1</xref>"));
        MarkupToDitaTaskTest.assertTrue((boolean)secondTopicContent.contains("<xref href=\"#Id2\">ref to 2</xref>"));
    }

    public void testCreatesSingleTopicXref() throws IOException {
        File markupFile = this.createTextileMarkupWithXref();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.setFilenameFormat("$1.dita");
        this.ditaTask.setTopicStrategy(MarkupToDitaTask.BreakStrategy.NONE);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertFalse((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.tempFolder, "markup.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        String firstTopicContent = this.getContent(firstHeadingFile);
        TestUtil.println(firstTopicContent);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"Id1\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>First Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<xref href=\"#Id2\">ref to 2</xref>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"Id2\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>Second Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<xref href=\"#Id1\">ref to 1</xref>"));
    }

    public void testCreatesSingleTopicXref_HL2() throws IOException {
        File markupFile = this.createTextileMarkupWithXref(2);
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.setFilenameFormat("$1.dita");
        this.ditaTask.setTopicStrategy(MarkupToDitaTask.BreakStrategy.NONE);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertFalse((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.tempFolder, "markup.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        String firstTopicContent = this.getContent(firstHeadingFile);
        TestUtil.println(firstTopicContent);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"Id1\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>First Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<xref href=\"#Id2\">ref to 2</xref>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"Id2\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>Second Heading</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<xref href=\"#Id1\">ref to 1</xref>"));
    }

    public void testFileNaming() throws IOException {
        File markupFile = this.createSimpleTextileMarkupWithFQNHeadings();
        this.ditaTask.setBookTitle("Sample Title");
        this.ditaTask.setFile(markupFile);
        this.ditaTask.execute();
        this.listFiles();
        File ditamapFile = new File(this.tempFolder, "markup.ditamap");
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapFile.exists());
        File firstHeadingFile = new File(this.topicsFolder, String.valueOf(MarkupToDitaTaskTest.class.getName()) + ".dita");
        MarkupToDitaTaskTest.assertTrue((boolean)firstHeadingFile.exists());
        File secondHeadingFile = new File(this.topicsFolder, "SecondHeading.dita");
        MarkupToDitaTaskTest.assertTrue((boolean)secondHeadingFile.exists());
        String ditamapContent = this.getContent(ditamapFile);
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<bookmap>"));
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<chapter href=\"topics/" + MarkupToDitaTaskTest.class.getName() + ".dita\" navtitle=\"" + MarkupToDitaTaskTest.class.getName() + "\"/>"));
        MarkupToDitaTaskTest.assertTrue((boolean)ditamapContent.contains("<chapter href=\"topics/SecondHeading.dita\" navtitle=\"Second Heading\"/>"));
        String firstTopicContent = this.getContent(firstHeadingFile);
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<topic id=\"" + MarkupToDitaTaskTest.class.getName() + "\">"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<title>" + MarkupToDitaTaskTest.class.getName() + "</title>"));
        MarkupToDitaTaskTest.assertTrue((boolean)firstTopicContent.contains("<p>some content</p>"));
    }

    public void testTaskdef() {
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(MarkupToDitaTask.class.getPackage().getName()) + ".tasks");
        MarkupToDitaTaskTest.assertEquals((String)MarkupToDitaTask.class.getName(), (String)bundle.getString("wikitext-to-dita"));
    }
}

