/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.hudson.core.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.HTML;
import javax.xml.bind.JAXBException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.cookie.Cookie;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;
import org.eclipse.mylyn.commons.core.HtmlUtil;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpOperation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonException;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonLoginForm;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonResourceNotFoundException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HudsonOperation<T>
extends CommonHttpOperation<T> {
    private static final String ID_CONTEXT_CRUMB = ".crumb";

    public HudsonOperation(CommonHttpClient client) {
        super(client);
    }

    protected void authenticate(IOperationMonitor monitor) throws IOException {
        UserCredentials credentials = (UserCredentials)this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY);
        if (credentials == null) {
            throw new IllegalStateException("Authentication requested without valid credentials");
        }
        HttpPost request = this.createPostRequest(String.valueOf(this.getClient().getLocation().getUrl()) + "/j_acegi_security_check");
        HudsonLoginForm form = new HudsonLoginForm();
        form.j_username = credentials.getUserName();
        form.j_password = credentials.getPassword();
        form.from = "";
        request.setEntity((HttpEntity)form.createEntity());
        HttpResponse response = this.getClient().execute((HttpRequestBase)request, monitor);
        try {
            this.validate(response, monitor);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 302) {
                this.getClient().setAuthenticated(false);
                throw new IOException(NLS.bind((String)"Unexpected response from Hudson server while logging in: {0}", (Object)HttpUtil.getStatusText((int)statusCode)));
            }
            Header header = response.getFirstHeader("Location");
            if (header != null && header.getValue().endsWith("/loginError")) {
                this.getClient().setAuthenticated(false);
                throw new AuthenticationException("Authentication failed", new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY));
            }
            this.getClient().setAuthenticated(this.hasValidatAuthenticationState());
        }
        finally {
            HttpUtil.release((HttpRequest)request, (HttpResponse)response, (IProgressMonitor)monitor);
        }
        this.updateCrumb(monitor);
    }

    private void updateCrumb(IOperationMonitor monitor) throws IOException {
        HttpGet request = this.createGetRequest(this.getClient().getLocation().getUrl());
        HttpResponse response = this.getClient().execute((HttpRequestBase)request, monitor);
        try {
            InputStream in = HttpUtil.getResponseBodyAsStream((HttpEntity)response.getEntity(), (IProgressMonitor)monitor);
            try {
                try {
                    String charSet = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, charSet != null ? charSet : "UTF-8"));
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                    HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                    while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                        HtmlTag tag;
                        if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.SCRIPT) {
                            String text = HtmlUtil.getTextContent((HtmlStreamTokenizer)tokenizer);
                            Pattern pattern = Pattern.compile("crumb.init\\(\".*\",\\s*\"([a-zA-Z0-9]*)\"\\)");
                            Matcher matcher = pattern.matcher(text);
                            if (matcher.find()) {
                                this.getClient().getContext().setAttribute(ID_CONTEXT_CRUMB, (Object)matcher.group(1));
                                break;
                            }
                        }
                        token = tokenizer.nextToken();
                    }
                }
                catch (ParseException parseException) {
                    in.close();
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            HttpUtil.release((HttpRequest)request, (HttpResponse)response, (IProgressMonitor)monitor);
        }
    }

    public T run() throws HudsonException {
        try {
            return this.execute();
        }
        catch (IOException e) {
            throw new HudsonException(e);
        }
        catch (JAXBException e) {
            throw new HudsonException(e);
        }
    }

    protected T doProcess(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, HudsonException, JAXBException {
        return null;
    }

    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, HudsonException {
        this.validate(response, 200, monitor);
    }

    protected abstract T execute() throws IOException, HudsonException, JAXBException;

    protected T process(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, HudsonException, JAXBException {
        try {
            this.doValidate(response, monitor);
            return this.doProcess(response, monitor);
        }
        catch (IOException e) {
            response.release((IProgressMonitor)monitor);
            throw e;
        }
        catch (HudsonException e) {
            response.release((IProgressMonitor)monitor);
            throw e;
        }
        catch (JAXBException e) {
            response.release((IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            response.release((IProgressMonitor)monitor);
            throw e;
        }
    }

    protected HttpPost createPostRequest(String requestPath) {
        HttpPost post = super.createPostRequest(requestPath);
        String crumb = (String)this.getClient().getContext().getAttribute(ID_CONTEXT_CRUMB);
        if (crumb != null) {
            post.addHeader(ID_CONTEXT_CRUMB, crumb);
        }
        return post;
    }

    protected T processAndRelease(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, HudsonException, JAXBException {
        try {
            this.doValidate(response, monitor);
            T t = this.doProcess(response, monitor);
            return t;
        }
        finally {
            response.release((IProgressMonitor)monitor);
        }
    }

    protected void validate(CommonHttpResponse response, int expected, IOperationMonitor monitor) throws HudsonException {
        int statusCode = response.getStatusCode();
        if (statusCode != expected) {
            if (statusCode == 404) {
                throw new HudsonResourceNotFoundException(NLS.bind((String)"Requested resource ''{0}'' does not exist", (Object)response.getRequestPath()));
            }
            throw new HudsonException(NLS.bind((String)"Unexpected response from Hudson server for ''{0}'': {1}", (Object)response.getRequestPath(), (Object)HttpUtil.getStatusText((int)statusCode)));
        }
    }

    protected boolean needsAuthentication() {
        if (this.hasCredentials()) {
            boolean authenticated = this.getClient().isAuthenticated() && this.hasValidatAuthenticationState();
            return !authenticated;
        }
        return false;
    }

    private boolean hasCredentials() {
        return this.getClient().getLocation().getCredentials(AuthenticationType.REPOSITORY, false) != null;
    }

    private boolean hasValidatAuthenticationState() {
        ArrayList cookies = new ArrayList(this.getClient().getHttpClient().getCookieStore().getCookies());
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"JSESSIONID".equals(cookie.getName())) continue;
                return !cookie.isExpired(new Date());
            }
        }
        return false;
    }

    protected void validate(HttpResponse response, IOperationMonitor monitor) throws AuthenticationException {
        super.validate(response, monitor);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 403) {
            AuthenticationRequest request = new AuthenticationRequest(this.getClient().getLocation(), AuthenticationType.REPOSITORY);
            throw new AuthenticationException(HttpUtil.getStatusText((int)statusCode), request, true);
        }
    }
}

