/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class ReviewItemLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    final StyledString.Styler NO_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };
    private final CommonImageManger imageManager = new CommonImageManger();

    public void dispose() {
        super.dispose();
        this.imageManager.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof IReviewItem) {
            IReviewItem item = (IReviewItem)element;
            return this.imageManager.getFileImage(item.getName());
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IReviewItem) {
            return ((IReviewItem)element).getName();
        }
        return super.getText(element);
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text != null) {
            IFileItem fileItem;
            StyledString styledString = new StyledString(text);
            if (element instanceof IFileItem && (fileItem = (IFileItem)element).getBase() != null && fileItem.getTarget() != null) {
                Stats stats = new Stats();
                this.count(stats, fileItem.getTopics());
                this.count(stats, fileItem.getBase().getTopics());
                this.count(stats, fileItem.getTarget().getTopics());
                if (stats.comments > 0 && stats.drafts > 0) {
                    styledString.append(NLS.bind((String)"  [{0} comments, {1} drafts]", (Object)stats.comments, (Object)stats.drafts), StyledString.DECORATIONS_STYLER);
                } else if (stats.comments > 0) {
                    styledString.append(NLS.bind((String)"  [{0} comments]", (Object)stats.comments), StyledString.DECORATIONS_STYLER);
                } else if (stats.drafts > 0) {
                    styledString.append(NLS.bind((String)"  [{0} drafts]", (Object)stats.drafts), StyledString.DECORATIONS_STYLER);
                }
            }
            return styledString;
        }
        return new StyledString();
    }

    private void count(Stats stats, List<ITopic> topics) {
        for (ITopic topic : topics) {
            if (topic.isDraft()) {
                ++stats.drafts;
                continue;
            }
            ++stats.comments;
        }
    }

    private class Stats {
        int drafts;
        int comments;

        private Stats() {
        }
    }
}

