/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.client.TracRemoteException;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;
import org.eclipse.mylyn.internal.trac.core.model.TracAction;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPageInfo;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.mylyn.trac.tests.support.TracTestConstants;
import org.eclipse.mylyn.trac.tests.support.TracTestUtil;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

public class TracXmlRpcClientTest
extends TestCase {
    protected List<XmlRpcServer.Ticket> tickets;
    private XmlRpcServer.TestData data;
    private ITracClient client;

    protected void setUp() throws Exception {
        super.setUp();
        this.client = TracFixture.current().connect();
        this.data = TracFixture.init010();
        this.tickets = this.data.tickets;
    }

    public void testValidateFailNoAuth() throws Exception {
        this.client = TracFixture.current().connect(TracTestConstants.TEST_TRAC_010_URL, "", "");
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            TracXmlRpcClientTest.fail((String)"Expected TracPermissiongDeniedException");
        }
        catch (TracPermissionDeniedException tracPermissionDeniedException) {}
    }

    public void testMulticallExceptions() throws Exception {
        try {
            ((TracXmlRpcClient)this.client).getTickets(new int[]{1, Integer.MAX_VALUE}, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
    }

    public void testSingleCallExceptions() throws Exception {
        try {
            ((TracXmlRpcClient)this.client).getTicketLastChanged(Integer.valueOf(Integer.MAX_VALUE), null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
    }

    public void testUpdateAttributes() throws Exception {
        TracXmlRpcClientTest.assertNull((Object)this.client.getMilestones());
        this.client.updateAttributes((IProgressMonitor)new NullProgressMonitor(), true);
        TracVersion[] versions = this.client.getVersions();
        TracXmlRpcClientTest.assertEquals((int)2, (int)versions.length);
        Arrays.sort(versions, new Comparator<TracVersion>(){

            @Override
            public int compare(TracVersion o1, TracVersion o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TracXmlRpcClientTest.assertEquals((String)"1.0", (String)versions[0].getName());
        TracXmlRpcClientTest.assertEquals((String)"", (String)versions[0].getDescription());
        TracXmlRpcClientTest.assertEquals((Object)new Date(0L), (Object)versions[0].getTime());
        TracXmlRpcClientTest.assertEquals((String)"2.0", (String)versions[1].getName());
        TracXmlRpcClientTest.assertEquals((String)"", (String)versions[1].getDescription());
        TracXmlRpcClientTest.assertEquals((Object)new Date(0L), (Object)versions[1].getTime());
    }

    public void testSearchValidateTicket() throws Exception {
        TracSearch search = new TracSearch();
        search.addFilter("summary", "summary1");
        ArrayList result = new ArrayList();
        this.client.search(search, result, null);
        TracXmlRpcClientTest.assertEquals((int)1, (int)result.size());
        TracTestUtil.assertTicketEquals(this.tickets.get(0), (TracTicket)result.get(0));
        TracXmlRpcClientTest.assertEquals((String)"component1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.COMPONENT));
        TracXmlRpcClientTest.assertEquals((String)"description1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.DESCRIPTION));
        TracXmlRpcClientTest.assertEquals((String)"milestone1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.MILESTONE));
        TracXmlRpcClientTest.assertEquals((String)"anonymous", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.REPORTER));
        TracXmlRpcClientTest.assertEquals((String)"summary1", (String)((TracTicket)result.get(0)).getValue(TracTicket.Key.SUMMARY));
    }

    public void testGetTicketActions() throws Exception {
        if (this.client.getUrl().equals(TracTestConstants.TEST_TRAC_010_URL)) {
            TracTicket ticket = this.client.getTicket(this.tickets.get(0).getId(), null);
            TracAction[] actions = ticket.getActions();
            TracXmlRpcClientTest.assertNotNull((Object)actions);
            TracXmlRpcClientTest.assertEquals((int)4, (int)actions.length);
            TracXmlRpcClientTest.assertEquals((String)"leave", (String)actions[0].getId());
            TracXmlRpcClientTest.assertNull((Object)actions[0].getLabel());
            TracXmlRpcClientTest.assertEquals((int)0, (int)actions[0].getFields().size());
            TracXmlRpcClientTest.assertEquals((String)"resolve", (String)actions[1].getId());
            TracXmlRpcClientTest.assertNull((Object)actions[1].getLabel());
            TracXmlRpcClientTest.assertEquals((int)0, (int)actions[1].getFields().size());
            TracXmlRpcClientTest.assertEquals((String)"reassign", (String)actions[2].getId());
            TracXmlRpcClientTest.assertNull((Object)actions[2].getLabel());
            TracXmlRpcClientTest.assertEquals((int)0, (int)actions[2].getFields().size());
            TracXmlRpcClientTest.assertEquals((String)"accept", (String)actions[3].getId());
            TracXmlRpcClientTest.assertNull((Object)actions[3].getLabel());
            TracXmlRpcClientTest.assertEquals((int)0, (int)actions[3].getFields().size());
            ticket = this.client.getTicket(this.tickets.get(1).getId(), null);
            actions = ticket.getActions();
            TracXmlRpcClientTest.assertNotNull((Object)actions);
            TracXmlRpcClientTest.assertEquals((int)2, (int)actions.length);
            TracXmlRpcClientTest.assertEquals((String)"leave", (String)actions[0].getId());
            TracXmlRpcClientTest.assertEquals((String)"reopen", (String)actions[1].getId());
        } else {
            TracTicket ticket = this.client.getTicket(this.tickets.get(0).getId(), null);
            TracAction[] actions = ticket.getActions();
            TracXmlRpcClientTest.assertNotNull((Object)actions);
            TracXmlRpcClientTest.assertEquals((int)4, (int)actions.length);
            TracXmlRpcClientTest.assertEquals((String)"leave", (String)actions[0].getId());
            TracXmlRpcClientTest.assertEquals((String)"resolve", (String)actions[1].getId());
            TracXmlRpcClientTest.assertEquals((String)"resolve", (String)actions[1].getLabel());
            TracXmlRpcClientTest.assertNotNull((Object)actions[1].getHint());
            List fields = actions[1].getFields();
            TracXmlRpcClientTest.assertEquals((int)1, (int)fields.size());
            TracXmlRpcClientTest.assertEquals((int)5, (int)((TracTicketField)fields.get(0)).getOptions().length);
            TracXmlRpcClientTest.assertEquals((String)"fixed", (String)((TracTicketField)fields.get(0)).getOptions()[0]);
            TracXmlRpcClientTest.assertEquals((String)"reassign", (String)actions[2].getId());
            fields = actions[2].getFields();
            TracXmlRpcClientTest.assertEquals((int)1, (int)fields.size());
            TracXmlRpcClientTest.assertNull((Object)((TracTicketField)fields.get(0)).getOptions());
            TracXmlRpcClientTest.assertEquals((String)"accept", (String)actions[3].getId());
            ticket = this.client.getTicket(this.tickets.get(1).getId(), null);
            actions = ticket.getActions();
            TracXmlRpcClientTest.assertNotNull((Object)actions);
            TracXmlRpcClientTest.assertEquals((int)2, (int)actions.length);
            TracXmlRpcClientTest.assertEquals((String)"leave", (String)actions[0].getId());
            TracXmlRpcClientTest.assertEquals((String)"reopen", (String)actions[1].getId());
        }
    }

    public void testWikiToHtml() throws Exception {
        String tracUrl = this.client.getUrl();
        String html = ((TracXmlRpcClient)this.client).wikiToHtml("", null);
        TracXmlRpcClientTest.assertEquals((String)"", (String)html);
        html = ((TracXmlRpcClient)this.client).wikiToHtml("A simple line of text.", null);
        TracXmlRpcClientTest.assertEquals((String)"<p>\nA simple line of text.\n</p>\n", (String)html);
        String source = "= WikiFormattingTesting =\n * '''bold''', '''!''' can be bold too''', and '''! '''\n * ''italic''\n * '''''bold italic'''''\n * __underline__\n * {{{monospace}}} or `monospace`\n * ~~strike-through~~\n * ^superscript^ \n * ,,subscript,,\n= Heading =\n== Subheading ==\n";
        String expectedHtml = TracFixture.current().getVersion().compareTo("0.12") >= 0 ? "<h1 id=\"WikiFormattingTesting\"><a class=\"missing wiki\" href=\"" + tracUrl + "/wiki/WikiFormattingTesting\" rel=\"nofollow\">WikiFormattingTesting?</a></h1>\n<ul><li><strong>bold</strong>, <strong>''' can be bold too</strong>, and <strong>! </strong>\n</li><li><em>italic</em>\n</li><li><strong><em>bold italic</em></strong>\n</li><li><span class=\"underline\">underline</span>\n</li><li><tt>monospace</tt> or <tt>monospace</tt>\n</li><li><del>strike-through</del>\n</li><li><sup>superscript</sup> \n</li><li><sub>subscript</sub>\n</li></ul><h1 id=\"Heading\">Heading</h1>\n<h2 id=\"Subheading\">Subheading</h2>\n" : "<h1 id=\"WikiFormattingTesting\"><a class=\"missing wiki\" href=\"" + tracUrl + "/wiki/WikiFormattingTesting\" rel=\"nofollow\">WikiFormattingTesting?</a></h1>\n<ul><li><strong>bold</strong>, <strong>''' can be bold too</strong>, and <strong>! </strong>\n</li><li><i>italic</i>\n</li><li><strong><i>bold italic</i></strong>\n</li><li><span class=\"underline\">underline</span>\n</li><li><tt>monospace</tt> or <tt>monospace</tt>\n</li><li><del>strike-through</del>\n</li><li><sup>superscript</sup> \n</li><li><sub>subscript</sub>\n</li></ul><h1 id=\"Heading\">Heading</h1>\n<h2 id=\"Subheading\">Subheading</h2>\n";
        html = ((TracXmlRpcClient)this.client).wikiToHtml(source, null);
        TracXmlRpcClientTest.assertEquals((String)expectedHtml, (String)html);
    }

    public void testValidateWikiAPI() throws Exception {
        ((TracXmlRpcClient)this.client).validateWikiRpcApi(null);
    }

    public void testGetAllWikiPageNames() throws Exception {
        String[] names = ((TracXmlRpcClient)this.client).getAllWikiPageNames(null);
        List<String> all = Arrays.asList(names);
        TracXmlRpcClientTest.assertTrue((boolean)all.contains("Test"));
    }

    public void testGetWikiPage() throws Exception {
        TracWikiPage page = ((TracXmlRpcClient)this.client).getWikiPage("TestGetPage", null);
        TracXmlRpcClientTest.assertEquals((String)"TestGetPage", (String)page.getPageInfo().getPageName());
        TracXmlRpcClientTest.assertEquals((String)"tests@mylyn.eclipse.org", (String)page.getPageInfo().getAuthor());
        TracXmlRpcClientTest.assertEquals((int)2, (int)page.getPageInfo().getVersion());
        TracXmlRpcClientTest.assertEquals((String)"Version 2", (String)page.getContent());
        TracXmlRpcClientTest.assertTrue((boolean)page.getPageHTML().startsWith("<html>"));
        page = ((TracXmlRpcClient)this.client).getWikiPage("TestGetPage", 1, null);
        TracXmlRpcClientTest.assertEquals((String)"TestGetPage", (String)page.getPageInfo().getPageName());
        TracXmlRpcClientTest.assertEquals((String)"anonymous", (String)page.getPageInfo().getAuthor());
        TracXmlRpcClientTest.assertEquals((int)1, (int)page.getPageInfo().getVersion());
        TracXmlRpcClientTest.assertEquals((String)"Version 1", (String)page.getContent());
        TracXmlRpcClientTest.assertTrue((boolean)page.getPageHTML().startsWith("<html>"));
    }

    public void testGetWikiPageInvalid() throws Exception {
        try {
            ((TracXmlRpcClient)this.client).getWikiPageInfo("Test", 10, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageInfo("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageInfo(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageContent("Test", 10, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageContent("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageContent(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageHtml("Test", 10, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageHtml("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageHtml(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPage("Test", 10, null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPage("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPage(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageInfoAllVersions("NoSuchPage", null);
            TracXmlRpcClientTest.fail((String)"Expected TracRemoteException");
        }
        catch (TracRemoteException tracRemoteException) {}
        try {
            ((TracXmlRpcClient)this.client).getWikiPageInfoAllVersions(null, null);
            TracXmlRpcClientTest.fail((String)"Expected RuntimeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testGetWikiPageInfoAllVersions() throws Exception {
        String pageName = "Test";
        TracWikiPageInfo[] versions = ((TracXmlRpcClient)this.client).getWikiPageInfoAllVersions(pageName, null);
        TracXmlRpcClientTest.assertTrue((versions.length >= 1 ? 1 : 0) != 0);
        int counter = 1;
        TracWikiPageInfo[] tracWikiPageInfoArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            TracWikiPageInfo version = tracWikiPageInfoArray[n2];
            TracXmlRpcClientTest.assertTrue((boolean)version.getPageName().equals(pageName));
            TracXmlRpcClientTest.assertTrue((version.getVersion() == counter++ ? 1 : 0) != 0);
            ++n2;
        }
    }

    public void testGetRecentWikiChanges() throws Exception {
        TracWikiPageInfo[] changes = ((TracXmlRpcClient)this.client).getRecentWikiChanges(new Date(0L), null);
        TracWikiPageInfo testPage = null;
        TracWikiPageInfo[] tracWikiPageInfoArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            TracWikiPageInfo item = tracWikiPageInfoArray[n2];
            TracXmlRpcClientTest.assertTrue((item.getPageName() != null ? 1 : 0) != 0);
            if (item.getPageName().equals("Test")) {
                testPage = item;
            }
            ++n2;
        }
        TracXmlRpcClientTest.assertTrue((testPage != null ? 1 : 0) != 0);
    }

    public void testPutWikiPage() throws Exception {
    }

    public void testInvalidCharacters() throws Exception {
        TracTicket ticket = TracTestUtil.createTicket(this.client, "invalid characters");
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "Control Character: \u0002");
        try {
            this.client.updateTicket(ticket, "set invalid characters in description", null);
            TracXmlRpcClientTest.fail((String)"Expected TracException");
        }
        catch (TracException tracException) {}
    }
}

