/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.trac.tests.support.XmlRpcServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracTestUtil {
    public static TracTicket createTicket(ITracClient client, String summary) throws Exception {
        TracTicket ticket = new TracTicket();
        ticket.putBuiltinValue(TracTicket.Key.SUMMARY, summary);
        ticket.putBuiltinValue(TracTicket.Key.DESCRIPTION, "");
        int id = client.createTicket(ticket, null);
        return client.getTicket(id, null);
    }

    public static ITask createTask(TaskRepository taskRepository, String taskId) throws Exception {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)"trac");
        TaskData taskData = connector.getTaskData(taskRepository, taskId, null);
        ITask task = TasksUi.getRepositoryModel().createTask(taskRepository, taskData.getTaskId());
        TasksUiPlugin.getTaskDataManager().putUpdatedTaskData(task, taskData, true);
        return task;
    }

    public static List<ITaskAttachment> getTaskAttachments(ITask task) throws CoreException {
        TaskData taskData = TasksUi.getTaskDataManager().getTaskData(task);
        ArrayList<ITaskAttachment> attachments = new ArrayList<ITaskAttachment>();
        List attributes = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
        if (attributes != null) {
            for (TaskAttribute taskAttribute : attributes) {
                ITaskAttachment taskAttachment = TasksUiPlugin.getRepositoryModel().createTaskAttachment(taskAttribute);
                taskData.getAttributeMapper().updateTaskAttachment(taskAttachment, taskAttribute);
                attachments.add(taskAttachment);
            }
        }
        return attachments;
    }

    public static void assertTicketEquals(XmlRpcServer.Ticket ticket, TracTicket tracTicket) throws Exception {
        Assert.assertTrue((boolean)tracTicket.isValid());
        Map<?, ?> expectedValues = ticket.getValues();
        Map values = tracTicket.getValues();
        for (String key : values.keySet()) {
            Object expected = expectedValues.get(key);
            String actual = (String)values.get(key);
            if (key.equals("reporter")) {
                String expectedString;
                int i;
                if (actual != null && actual.endsWith("\u2026") && expected instanceof String && (i = (expectedString = (String)expected).indexOf("@")) != -1) {
                    expected = String.valueOf(expectedString.substring(0, i + 1)) + "\u2026";
                }
            } else if (key.startsWith("_")) continue;
            Assert.assertEquals((String)("Values for key '" + key + "' did not match"), expected, (Object)actual);
        }
    }
}

