/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;

public class XmlRpcServer {
    private final XmlRpcClient client;
    private final TestData data;
    private final String password;
    private final TracXmlRpcClient repository;
    private final String url;
    private final String username;

    public XmlRpcServer(String url, String username, String password) throws Exception {
        this.url = url;
        this.username = username;
        this.password = password;
        this.data = new TestData();
        this.repository = new TracXmlRpcClient((AbstractWebLocation)new WebLocation(url, username, password), ITracClient.Version.XML_RPC);
        this.client = this.repository.getClient();
    }

    private Object call(String method, Object ... parameters) throws XmlRpcException, IOException {
        Vector<Object> params = new Vector<Object>(parameters.length);
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object parameter = objectArray[n2];
            params.add(parameter);
            ++n2;
        }
        Object result = this.client.execute(method, params);
        if (result instanceof XmlRpcException) {
            throw (XmlRpcException)((Object)result);
        }
        return result;
    }

    public TestData getData() {
        return this.data;
    }

    public String getPassword() {
        return this.password;
    }

    public TracXmlRpcClient getRepository() throws MalformedURLException {
        return this.repository;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public Ticket ticket() throws Exception {
        return new Ticket(null);
    }

    public Ticket ticket(int id) throws Exception {
        return new Ticket(id);
    }

    public ModelEnum ticketComponent(String id) throws Exception {
        return new ModelEnum("ticket.component", id, "owner", "description");
    }

    public ModelEnum ticketMilestone(String id) throws Exception {
        return new ModelEnum("ticket.milestone", id, "due", "completed", "description");
    }

    public TicketEnum ticketPriority(String id) throws Exception {
        return new TicketEnum("ticket.priority", id);
    }

    public TicketEnum ticketSeverity(String id) throws Exception {
        return new TicketEnum("ticket.severity", id);
    }

    public TicketEnum ticketStatus(String id) throws Exception {
        return new TicketEnum("ticket.status", id);
    }

    public TicketEnum ticketType(String id) throws Exception {
        return new TicketEnum("ticket.type", id);
    }

    public ModelEnum ticketVersion(String id) throws Exception {
        return new ModelEnum("ticket.version", id, "time", "description");
    }

    public abstract class AbstractTracItem {
        public abstract void delete() throws Exception;

        void itemCreated() {
            ((XmlRpcServer)XmlRpcServer.this).data.items.add(this);
        }

        void itemDeleted() {
            ((XmlRpcServer)XmlRpcServer.this).data.items.remove(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ModelEnum
    extends AbstractTracItem {
        private final String[] attributes;
        private final String id;
        private final String module;

        public ModelEnum(String module, String id, String ... attributes) {
            this.module = module;
            this.id = id;
            this.attributes = attributes;
        }

        public ModelEnum create(Object ... params) throws Exception {
            XmlRpcServer.this.call(String.valueOf(this.module) + ".create", new Object[]{this.id, this.toMap(params)});
            this.itemCreated();
            return this;
        }

        @Override
        public void delete() throws Exception {
            XmlRpcServer.this.call(String.valueOf(this.module) + ".delete", new Object[]{this.id});
            this.itemDeleted();
        }

        public void deleteAll() throws Exception {
            String[] ids;
            String[] stringArray = ids = this.getAll();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                XmlRpcServer.this.call(String.valueOf(this.module) + ".delete", new Object[]{id});
                ++n2;
            }
        }

        public ModelEnum deleteAndCreate(Object ... params) throws Exception {
            if (Arrays.asList(this.getAll()).contains(this.id)) {
                this.delete();
            }
            return this.create(params);
        }

        public Object[] get() throws Exception {
            Hashtable values = (Hashtable)XmlRpcServer.this.call(String.valueOf(this.module) + ".get", new Object[]{this.id});
            Object[] result = new Object[values.size()];
            int i = 0;
            while (i < result.length && i < this.attributes.length) {
                result[i] = values.get(this.attributes[i]);
                ++i;
            }
            return result;
        }

        public String[] getAll() throws Exception {
            return Arrays.asList((Object[])XmlRpcServer.this.call(String.valueOf(this.module) + ".getAll", new Object[0])).toArray(new String[0]);
        }

        private Hashtable<String, Object> toMap(Object ... params) {
            Hashtable<String, Object> attrs = new Hashtable<String, Object>();
            int i = 0;
            while (i < this.attributes.length && i < params.length) {
                attrs.put(this.attributes[i], params[i]);
                ++i;
            }
            return attrs;
        }

        public ModelEnum update(Object ... params) throws Exception {
            XmlRpcServer.this.call(String.valueOf(this.module) + ".update", new Object[]{this.id, this.toMap(params)});
            return this;
        }
    }

    public class TestData {
        List<AbstractTracItem> items = new ArrayList<AbstractTracItem>();
        public List<Ticket> tickets = new ArrayList<Ticket>();
        public int attachmentTicketId = 5;
        public int htmlEntitiesTicketId = 6;
        public int offlineHandlerTicketId = 7;

        public void cleanup() throws Exception {
            while (!this.items.isEmpty()) {
                this.items.get(0).delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Ticket
    extends AbstractTracItem {
        private Integer id;

        public Ticket(Integer id) {
            this.id = id;
        }

        public Ticket create(String summary, String description) throws Exception {
            this.id = (Integer)XmlRpcServer.this.call("ticket.create", new Object[]{summary, description, new Hashtable()});
            if (this.id == null) {
                throw new RuntimeException("Could not create ticket: " + summary);
            }
            this.itemCreated();
            return this;
        }

        @Override
        public void delete() throws Exception {
            XmlRpcServer.this.call("ticket.delete", new Object[]{this.id});
            this.itemDeleted();
        }

        public void deleteAll() throws Exception {
            Integer[] ids;
            Integer[] integerArray = ids = this.getAll();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Integer id = integerArray[n2];
                XmlRpcServer.this.call("ticket.delete", new Object[]{id});
                ++n2;
            }
        }

        public Object getValue(String key) throws Exception {
            return this.getValues().get(key);
        }

        public Map<?, ?> getValues() throws Exception {
            return (Map)((Object[])XmlRpcServer.this.call("ticket.get", new Object[]{this.id}))[3];
        }

        public Integer[] getAll() throws Exception {
            return Arrays.asList((Object[])XmlRpcServer.this.call("ticket.query", new Object[]{"order=id"})).toArray(new Integer[0]);
        }

        public int getId() {
            return this.id;
        }

        @Override
        protected void itemCreated() {
            super.itemCreated();
            ((XmlRpcServer)XmlRpcServer.this).data.tickets.add(this);
        }

        @Override
        protected void itemDeleted() {
            super.itemDeleted();
            ((XmlRpcServer)XmlRpcServer.this).data.tickets.remove(this);
        }

        public Ticket update(String comment, String key, String value) throws Exception {
            Hashtable<String, String> attrs = new Hashtable<String, String>();
            attrs.put(key, value);
            XmlRpcServer.this.call("ticket.update", new Object[]{this.id, comment, attrs});
            return this;
        }
    }

    public class TicketEnum
    extends AbstractTracItem {
        private final String id;
        private final String module;

        public TicketEnum(String module, String id) {
            this.module = module;
            this.id = id;
        }

        public TicketEnum create(String param) throws Exception {
            XmlRpcServer.this.call(String.valueOf(this.module) + ".create", new Object[]{this.id, param});
            this.itemCreated();
            return this;
        }

        public void delete() throws Exception {
            XmlRpcServer.this.call(String.valueOf(this.module) + ".delete", new Object[]{this.id});
            this.itemDeleted();
        }

        public void deleteAll() throws Exception {
            String[] ids;
            String[] stringArray = ids = this.getAll();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                XmlRpcServer.this.call(String.valueOf(this.module) + ".delete", new Object[]{id});
                ++n2;
            }
        }

        public TicketEnum deleteAndCreate(String param) throws Exception {
            if (Arrays.asList(this.getAll()).contains(this.id)) {
                this.delete();
            }
            return this.create(param);
        }

        public String get() throws Exception {
            return (String)XmlRpcServer.this.call(String.valueOf(this.module) + ".get", new Object[]{this.id});
        }

        public String[] getAll() throws Exception {
            return Arrays.asList((Object[])XmlRpcServer.this.call(String.valueOf(this.module) + ".getAll", new Object[0])).toArray(new String[0]);
        }

        public TicketEnum update(String param) throws Exception {
            XmlRpcServer.this.call(String.valueOf(this.module) + ".update", new Object[]{this.id, param});
            return this;
        }
    }
}

