/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.ui;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.trac.tests.support.TracFixture;

public class TracRepositorySettingsPageTest
extends TestCase {
    private MyTracRepositorySettingsPage page;
    private TracRepositorySettingsPage.TracValidator validator;
    private WizardDialog dialog;

    protected void setUp() throws Exception {
        super.setUp();
        this.page = new MyTracRepositorySettingsPage(null);
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                return true;
            }
        };
        wizard.addPage((IWizardPage)this.page);
        this.dialog = new WizardDialog(null, (IWizard)wizard);
        this.dialog.create();
    }

    protected void tearDown() throws Exception {
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    protected void initialize(TracFixture fixture) throws Exception {
        TaskRepository repository = fixture.repository();
        this.page.setAnonymous(false);
        this.page.setUrl(repository.getRepositoryUrl());
        this.page.setUserId(repository.getCredentials(AuthenticationType.REPOSITORY).getUserName());
        this.page.setPassword(repository.getCredentials(AuthenticationType.REPOSITORY).getPassword());
        this.page.setTracVersion(fixture.getAccessMode());
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), fixture.getAccessMode());
    }

    public void testValidateXmlRpc() throws Exception {
        this.initialize(TracFixture.TRAC_0_10_XML_RPC);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid.", (String)this.page.getMessage());
    }

    public void testValidateWeb() throws Exception {
        this.initialize(TracFixture.TRAC_0_10_WEB);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid.", (String)this.page.getMessage());
    }

    public void testValidateAutomaticUser() throws Exception {
        this.initialize(TracFixture.TRAC_0_10_XML_RPC);
        this.page.setTracVersion(null);
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), null);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid.", (String)this.page.getMessage());
    }

    public void testValidateAutomaticAnonymous() throws Exception {
        this.initialize(TracFixture.TRAC_0_10_XML_RPC);
        this.page.setUserId("");
        this.page.setPassword("");
        this.page.setTracVersion(null);
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), null);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNotNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid. Note: Insufficient permissions for XML-RPC access, falling back to web access.", (String)this.page.getMessage());
    }

    public void testValidateInvalid() throws Exception {
        this.initialize(TracFixture.TRAC_INVALID);
        this.page.setTracVersion(null);
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), null);
        try {
            this.validator.run((IProgressMonitor)new NullProgressMonitor());
            TracRepositorySettingsPageTest.fail((String)"Expected CoreException");
        }
        catch (CoreException e) {
            this.validator.setStatus(e.getStatus());
        }
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertNull((Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((int)3, (int)this.page.getMessageType());
    }

    private static class MyTracRepositorySettingsPage
    extends TracRepositorySettingsPage {
        public MyTracRepositorySettingsPage(TaskRepository taskRepository) {
            super(taskRepository);
        }

        protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
            if (validator.getStatus() == null) {
                validator.setStatus(Status.OK_STATUS);
            }
            super.applyValidatorResult(validator);
        }
    }
}

