/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.git.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.mylyn.internal.git.core.GitArtifact;
import org.eclipse.mylyn.internal.git.core.GitRepository;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ChangeType;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.ScmUser;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.mylyn.versions.core.spi.ScmResourceArtifact;
import org.eclipse.mylyn.versions.core.spi.ScmResourceUtils;
import org.eclipse.team.core.history.IFileRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitConnector
extends ScmConnector {
    static String PLUGIN_ID = "org.eclipse.mylyn.git.core";

    public String getProviderId() {
        return GitProvider.class.getName();
    }

    public ScmArtifact getArtifact(IResource resource) throws CoreException {
        FileRepository fileRepo = this.getFileRepository(resource);
        String resRepoRelPath = this.resolveRepoRelativePath(fileRepo, resource);
        String revision = null;
        try {
            revision = this.resolveObject(fileRepo, resRepoRelPath);
        }
        catch (Exception exception) {}
        ScmArtifact artifact = null;
        if (revision != null) {
            GitRepository repo = this.getRepository(resource);
            artifact = new GitArtifact(revision, resRepoRelPath, repo);
            artifact.setProjectName(resource.getProject().getName());
            artifact.setProjectRelativePath(resource.getProjectRelativePath().toPortableString());
        } else {
            artifact = this.getArtifact(resource, null);
        }
        return artifact;
    }

    public ScmArtifact getArtifact(IResource resource, String revision) throws CoreException {
        return new ScmResourceArtifact((ScmConnector)this, resource, revision);
    }

    public ChangeSet getChangeSet(ScmRepository repository, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        Repository repository2 = ((GitRepository)repository).getRepository();
        RevWalk walk = new RevWalk(repository2);
        try {
            RevCommit commit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)revision.getContentIdentifier()));
            TreeWalk treeWalk = new TreeWalk(repository2);
            RevCommit[] revCommitArray = commit.getParents();
            if (revCommitArray.length != 0) {
                RevCommit p = revCommitArray[0];
                walk.parseHeaders((RevObject)p);
                walk.parseBody((RevObject)p);
                treeWalk.addTree((AnyObjectId)p.getTree());
            }
            treeWalk.addTree((AnyObjectId)commit.getTree());
            treeWalk.setRecursive(true);
            List entries = DiffEntry.scan((TreeWalk)treeWalk);
            ArrayList<Change> changes = new ArrayList<Change>();
            File repoDir = repository2.getWorkTree().getAbsoluteFile();
            IPath repoWorkAreaPath = new Path(repoDir.getAbsolutePath()).addTrailingSeparator();
            for (DiffEntry d : entries) {
                if (!d.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME) && d.getOldId().equals((Object)d.getNewId())) continue;
                ScmArtifact newArtifact = this.getArtifact(repository, d, false, repoWorkAreaPath);
                ScmArtifact oldArtifact = this.getArtifact(repository, d, true, repoWorkAreaPath);
                changes.add(new Change(oldArtifact, newArtifact, this.mapChangeType(d.getChangeType())));
            }
            return this.changeSet(commit, repository, changes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
        }
    }

    private ScmArtifact getArtifact(ScmRepository repository, DiffEntry d, boolean old, IPath repoWorkAreaPath) {
        GitArtifact artifact = null;
        String id = null;
        String path = null;
        if (old) {
            id = d.getOldId().name();
            path = d.getOldPath();
        } else {
            id = d.getNewId().name();
            path = d.getNewPath();
        }
        artifact = new GitArtifact(id, path, (GitRepository)repository);
        IFile ifile = null;
        IPath absPath = repoWorkAreaPath.append(path);
        URI absURI = URIUtil.toURI((IPath)absPath);
        IFile[] files = ScmResourceUtils.getWorkSpaceFiles((URI)absURI);
        if (files != null && files.length > 0) {
            ifile = files[0];
            artifact.setProjectName(ifile.getProject().getName());
            artifact.setProjectRelativePath(ifile.getProjectRelativePath().toPortableString());
        }
        return artifact;
    }

    private ChangeType mapChangeType(DiffEntry.ChangeType change) {
        switch (change) {
            case ADD: 
            case COPY: {
                return ChangeType.ADDED;
            }
            case DELETE: {
                return ChangeType.DELETED;
            }
            case MODIFY: {
                return ChangeType.MODIFIED;
            }
            case RENAME: {
                return ChangeType.REPLACED;
            }
        }
        return null;
    }

    public List<ChangeSet> getChangeSets(ScmRepository repository, IProgressMonitor monitor) throws CoreException {
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        try {
            Git git = new Git(((GitRepository)repository).getRepository());
            Iterable revs = git.log().call();
            for (RevCommit r : revs) {
                changeSets.add(this.changeSet(r, repository, new ArrayList<Change>()));
            }
        }
        catch (NoHeadException noHeadException) {}
        return changeSets;
    }

    private ChangeSet changeSet(RevCommit r, ScmRepository repository, List<Change> changes) {
        long adjTime = (long)r.getCommitTime() * 1000L;
        ChangeSet changeSet = new ChangeSet(this.getScmUser(r.getCommitterIdent()), new Date(adjTime), r.name(), r.getFullMessage(), repository, changes);
        return changeSet;
    }

    private ScmUser getScmUser(PersonIdent person) {
        return new ScmUser(person.getEmailAddress(), person.getName(), person.getEmailAddress());
    }

    public List<ScmRepository> getRepositories(IProgressMonitor monitor) throws CoreException {
        ArrayList<ScmRepository> repos = new ArrayList<ScmRepository>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            GitRepository repository = this.getRepository((IResource)project, monitor);
            if (repository != null) {
                repos.add(repository);
            }
            ++n2;
        }
        return repos;
    }

    public GitRepository getRepository(IResource resource, IProgressMonitor monitor) throws CoreException {
        return this.getRepository(resource);
    }

    public GitRepository getRepository(IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping == null) {
            return null;
        }
        return new GitRepository(this, mapping);
    }

    protected RepositoryCache getRepositoryCache() {
        return Activator.getDefault().getRepositoryCache();
    }

    private FileRepository getFileRepository(IResource resource) {
        if (resource == null) {
            return null;
        }
        RepositoryMapping m = RepositoryMapping.getMapping((IResource)resource);
        try {
            return new FileRepository(m.getGitDirAbsolutePath().toFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String resolveRepoRelativePath(FileRepository repo, IResource resource) {
        if (repo == null || resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        RepositoryMapping m = RepositoryMapping.getMapping((IResource)resource);
        try {
            repo = new FileRepository(m.getGitDirAbsolutePath().toFile());
            File workTree = repo.getWorkTree();
            IPath workTreePath = Path.fromOSString((String)workTree.getAbsolutePath());
            if (workTreePath.isPrefixOf(project.getLocation())) {
                IPath makeRelativeTo = resource.getLocation().makeRelativeTo(workTreePath);
                String repoRelativePath = makeRelativeTo.toPortableString();
                return repoRelativePath;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private String resolveObject(FileRepository repo, String repoRelativePath) throws AmbiguousObjectException, IOException {
        if (repo == null || repoRelativePath == null) {
            return null;
        }
        ObjectId headCommitId = repo.resolve("HEAD");
        String id = null;
        if (headCommitId != null) {
            RevWalk revWalk = new RevWalk((Repository)repo);
            RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headCommitId);
            RevTree headTree = headCommit.getTree();
            TreeWalk resourceInRepo = TreeWalk.forPath((Repository)repo, (String)repoRelativePath, (RevTree)headTree);
            if (resourceInRepo != null) {
                ObjectId objId = resourceInRepo.getObjectId(0);
                id = objId.getName();
            }
            revWalk.dispose();
        }
        return id;
    }
}

