/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.state;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.state.ContextState;
import org.eclipse.mylyn.internal.context.ui.state.ContextStateParticipant;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PerspectiveStateParticipant
extends ContextStateParticipant {
    public static final String KEY_ACTIVE_ID = "activeId";
    public static final String MEMENTO_PERSPECTIVE = "org.eclipse.mylyn.context.ui.perspectives";
    private final IPreferenceStore preferenceStore;

    public PerspectiveStateParticipant(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public void clearState(String contextHandle, boolean isActiveContext) {
    }

    public String getActivePerspectiveId() {
        IWorkbenchWindow launchingWindow;
        if (PlatformUI.isWorkbenchRunning() && (launchingWindow = this.getWorkbenchWindow()) != null) {
            return this.getActivePerspectiveId(launchingWindow);
        }
        return null;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                window = windows[0];
            }
            return window;
        }
        return null;
    }

    public boolean isEnabled() {
        return ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.perspectives.auto.manage");
    }

    public void restoreDefaultState(ContextState memento) {
        String previousPerspectiveId = this.getDefaultPerspectiveId();
        this.showPerspective(previousPerspectiveId);
    }

    public void restoreState(ContextState state) {
        IMemento memento;
        IWorkbenchWindow launchingWindow = this.getWorkbenchWindow();
        if (launchingWindow != null && (memento = state.getMemento(MEMENTO_PERSPECTIVE)) != null) {
            String perspectiveId = memento.getString(KEY_ACTIVE_ID);
            this.showPerspective(perspectiveId);
        }
    }

    public void saveDefaultState(ContextState memento) {
        String id = this.getActivePerspectiveId();
        if (id != null) {
            this.setDefaultPerspectiveId(id);
        }
    }

    public void saveState(ContextState state, boolean allowModifications) {
        String id = this.getActivePerspectiveId();
        if (id != null) {
            IMemento memento = state.createMemento(MEMENTO_PERSPECTIVE);
            memento.putString(KEY_ACTIVE_ID, id);
        }
    }

    private String getActivePerspectiveId(IWorkbenchWindow window) {
        Assert.isNotNull((Object)window);
        IPerspectiveDescriptor descriptor = window.getActivePage().getPerspective();
        return descriptor.getId();
    }

    private String getDefaultPerspectiveId() {
        return this.preferenceStore.getString("org.eclipse.mylyn.ui.perspectives.task.none");
    }

    private void setDefaultPerspectiveId(String perspectiveId) {
        this.preferenceStore.setValue("org.eclipse.mylyn.ui.perspectives.task.none", perspectiveId);
    }

    private void showPerspective(String perspectiveId) {
        IWorkbenchWindow launchingWindow;
        if (perspectiveId != null && perspectiveId.length() > 0 && (launchingWindow = this.getWorkbenchWindow()) != null) {
            try {
                try {
                    launchingWindow.getShell().setRedraw(false);
                    PlatformUI.getWorkbench().showPerspective(perspectiveId, launchingWindow);
                }
                catch (Exception exception) {
                    launchingWindow.getShell().setRedraw(true);
                }
            }
            finally {
                launchingWindow.getShell().setRedraw(true);
            }
        }
    }
}

