/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public abstract class AbstractHtmlBlock
extends Block {
    private final Pattern startPattern;
    private final Pattern endPattern;
    protected int blockLineCount = 0;
    private Matcher matcher;

    public AbstractHtmlBlock(String tagName) {
        this.startPattern = Pattern.compile("\\s*(<" + tagName + "((?:\\s*[a-zA-Z][a-zA-Z0-9_:-]*=\"[^\"]*\")*)\\s*>)(.*)");
        this.endPattern = Pattern.compile("\\s*(</" + tagName + "\\s*>)(.*)");
    }

    public int processLineContent(String line, int offset) {
        int end;
        if (this.blockLineCount == 0) {
            this.setAttributes(this.matcher.group(2));
            offset = this.matcher.start(3);
            this.beginBlock();
        }
        int segmentEnd = end = line.length();
        boolean terminating = false;
        if (offset < end) {
            Matcher endMatcher = this.endPattern.matcher(line);
            if (this.blockLineCount == 0) {
                endMatcher.region(offset, end);
            }
            if (endMatcher.find()) {
                terminating = true;
                end = endMatcher.start(2);
                segmentEnd = endMatcher.start(1);
            }
        }
        if (end < line.length()) {
            this.state.setLineSegmentEndOffset(end);
        }
        ++this.blockLineCount;
        String content = line.substring(offset, segmentEnd);
        this.handleBlockContent(content);
        if (terminating) {
            this.setClosed(true);
        }
        return end == line.length() ? -1 : end;
    }

    protected void setAttributes(String attributes) {
        if (attributes != null) {
            Pattern pattern = Pattern.compile("\\s+([a-zA-Z][a-zA-Z0-9_:-]*)=\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(attributes);
            while (matcher.find()) {
                String attrName = matcher.group(1);
                String attrValue = matcher.group(2);
                this.handleAttribute(attrName, attrValue);
            }
        }
    }

    protected void handleAttribute(String attrName, String attrValue) {
    }

    protected abstract void handleBlockContent(String var1);

    protected abstract void beginBlock();

    protected abstract void endBlock();

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.endBlock();
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        this.resetState();
        this.matcher = this.startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    protected void resetState() {
        this.blockLineCount = 0;
    }
}

