/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.compare.ByteArrayInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;

public class CompareUtil {
    public static DiffNode createDiffNode(IFileItem file) {
        String basePath;
        byte[] targetContent = CompareUtil.getContent(file.getTarget());
        byte[] baseContent = CompareUtil.getContent(file.getBase());
        String targetPath = file.getTarget().getPath();
        if (targetPath == null) {
            targetPath = file.getBase().getPath();
        }
        if ((basePath = file.getBase().getPath()) == null) {
            basePath = targetPath;
        }
        return new DiffNode((ITypedElement)new ByteArrayInput(targetContent, targetPath), (ITypedElement)new ByteArrayInput(baseContent, basePath));
    }

    public static byte[] getContent(IFileVersion version) {
        String content = version.getContent();
        return content != null ? content.getBytes() : new byte[]{};
    }

    static SourceViewer getSourceViewer(MergeSourceViewer sourceViewer) {
        if (SourceViewer.class.isInstance(sourceViewer)) {
            return (SourceViewer)SourceViewer.class.cast(sourceViewer);
        }
        try {
            Method getSourceViewerRefl = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerRefl.setAccessible(true);
            Object returnValue = getSourceViewerRefl.invoke((Object)sourceViewer, new Object[0]);
            if (returnValue instanceof SourceViewer) {
                return (SourceViewer)returnValue;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    static void setActiveViewer(TextMergeViewer mergeViewer, MergeSourceViewer focusViewer) {
        try {
            Method setActiveViewer = TextMergeViewer.class.getDeclaredMethod("setActiveViewer", MergeSourceViewer.class, Boolean.TYPE);
            setActiveViewer.setAccessible(true);
            setActiveViewer.invoke((Object)mergeViewer, focusViewer, true);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Failed to activate viewer", (Throwable)e));
        }
    }

    static void configureSourceViewers(Viewer contentViewer, TextMergeViewer textMergeViewer, MergeSourceViewer fLeft, MergeSourceViewer fRight) {
        try {
            Method getCompareConfiguration = ContentMergeViewer.class.getDeclaredMethod("getCompareConfiguration", new Class[0]);
            getCompareConfiguration.setAccessible(true);
            CompareConfiguration cc = (CompareConfiguration)getCompareConfiguration.invoke((Object)textMergeViewer, new Object[0]);
            Method getMergeContentProvider = ContentMergeViewer.class.getDeclaredMethod("getMergeContentProvider", new Class[0]);
            getMergeContentProvider.setAccessible(true);
            IMergeViewerContentProvider cp = (IMergeViewerContentProvider)getMergeContentProvider.invoke((Object)textMergeViewer, new Object[0]);
            Method getSourceViewer = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            Method configureSourceViewer = TextMergeViewer.class.getDeclaredMethod("configureSourceViewer", SourceViewer.class, Boolean.TYPE);
            configureSourceViewer.setAccessible(true);
            configureSourceViewer.invoke((Object)contentViewer, getSourceViewer.invoke((Object)fLeft, new Object[0]), cc.isLeftEditable() && cp.isLeftEditable(textMergeViewer.getInput()));
            configureSourceViewer.invoke((Object)contentViewer, getSourceViewer.invoke((Object)fRight, new Object[0]), cc.isRightEditable() && cp.isRightEditable(textMergeViewer.getInput()));
            Field isConfiguredField = TextMergeViewer.class.getDeclaredField("isConfigured");
            isConfiguredField.setAccessible(true);
            isConfiguredField.set(contentViewer, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

